/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPJSON
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPJSON> CLASS = LoadBalancerHTTPJSON.class;
    private final String COMPONENT_NAME = "JSON";
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "JSON";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        Map map = iHTTPRequest.getParameterMap();
        String string2 = iHTTPRequest.getRemoteAddr();
        String string3 = iHTTPRequest.getQueryString();
        Object object = "";
        if (map.containsKey("IP")) {
            try {
                string2 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string2 = "INVALID";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string2);
        hashMap.put("ClientStream", string);
        hashMap.put("ClientQueryString", string3);
        hashMap.put("ClientScheme", iHTTPRequest.isSecure() ? "true" : "false");
        hashMap.put("ClientPort", String.valueOf(iHTTPRequest.getServerPort()));
        ILoadBalancerServerClient iLoadBalancerServerClient = iLoadBalancerServer.processServerDataExtensions(hashMap);
        string3 = LoadBalancerHTTPProvider.removeKnownParameters(string3);
        iHTTPResponse.setHeader("Content-Type", "application/json");
        object = (String)object + "{\n";
        object = (String)object + "\"loadbalanceVersion\":\"" + ReleaseInfo.getVersion() + "\",\n";
        object = (String)object + "\"loadbalanceBuild\":\"" + ReleaseInfo.getBuildNumber() + "\"";
        if (iLoadBalancerServerClient != null) {
            object = (String)object + ",\n";
            object = (String)object + "\"loadbalanceScheme\":\"" + iLoadBalancerServerClient.getScheme() + "\",\n";
            object = (String)object + "\"loadbalanceHost\":\"" + iLoadBalancerServerClient.getClientHost() + "\",\n";
            object = (String)object + "\"loadbalanceAssetPath\":\"" + string + "\",\n";
            object = (String)object + "\"loadbalanceClientQueryString\":\"" + string3 + "\",\n";
            object = (String)object + "\"loadbalanceClientIP\":\"" + string2 + "\"";
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Redirection URL is: " + (String)object);
            }
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        object = (String)object + "\n}\n";
        return object;
    }
}

