/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.http.HTTPProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPProvider
extends HTTPProvider2Base {
    private static final Class<LoadBalancerHTTPProvider> CLASS = LoadBalancerHTTPProvider.class;
    private static final String LOAD_BALANCER_HTTP_CLASS_PATH = "com.wowza.wms.plugin.loadbalancer.http";
    private final HashMap<String, ILoadBalancerHTTPExtension> extensions = new HashMap();
    String[] httpExtensionClasses = new String[]{"com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPM3U8", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPManifest", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPF4M", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPDASH", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPSMIL", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPServer", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPClientRequest", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPXML", "com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPJSON"};
    ArrayList<String> loadHTTPExtensions = new ArrayList<String>(Arrays.asList(this.httpExtensionClasses));
    private String userHTTPHeaders = null;
    private boolean debug = true;
    private String defaultOutput = null;
    private ILoadBalancerServer loadBalanceServer = null;
    private Logger logger = null;

    public static String removeKnownParameters(String object) {
        object = ((String)object).length() == 0 ? "" : "?" + (String)object;
        object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "assets");
        object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "bitrates");
        object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "scheme");
        object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "request");
        object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "type");
        if (((String)(object = LoadBalancerHTTPProvider.removetriggerParameters((String)object, "manifestType"))).startsWith("&")) {
            object = ((String)object).substring(1);
            object = "?" + (String)object;
        }
        return object;
    }

    public static String removetriggerParameters(String string, String string2) {
        if (string.contains(string2)) {
            String string3 = string.substring(0, string.indexOf(string2) - 1);
            string = string.substring(string3.length() + 1);
            String string4 = "";
            if (string.indexOf("&") > 0) {
                String string5 = string.substring(0, string.indexOf("&"));
                string4 = string.substring(string5.length());
            }
            return string3 + string4;
        }
        return string;
    }

    public static String[] getLoadBalancedPath(String string) {
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = string.split("/");
        }
        catch (Exception exception) {
            stringArray2[0] = string;
        }
        String string2 = null;
        Object object = "";
        if (stringArray2.length < 2) {
            return stringArray2;
        }
        int n = 1;
        if (string.endsWith("/loadbalancer.smil")) {
            n = 2;
        }
        string2 = stringArray2[stringArray2.length - n];
        if (stringArray2.length <= 4 || stringArray2[2].contains(":")) {
            for (int i = 2; i < stringArray2.length - n; ++i) {
                object = (String)object + stringArray2[i] + "/";
            }
            stringArray[0] = stringArray2[1] + "/_definst_";
        } else {
            for (int i = 3; i < stringArray2.length - n; ++i) {
                object = (String)object + stringArray2[i] + "/";
            }
            stringArray[0] = stringArray2[1] + "/" + stringArray2[2];
        }
        if (((String)object).length() > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        stringArray[1] = object;
        stringArray[2] = LoadBalancerHTTPProvider.transformFormatFile((String)object, string2);
        return stringArray;
    }

    public static String transformFormatFile(String string, String string2) {
        String[] stringArray;
        if (string2.contains(":")) {
            return string2;
        }
        try {
            stringArray = string.split(":");
            if (stringArray.length > 1) {
                return string2;
            }
        }
        catch (Exception exception) {
            return string2;
        }
        try {
            stringArray = string2.split("\\.");
            if (stringArray.length == 1) {
                return string2;
            }
            String[] stringArray2 = new String[]{"flv", "mp4", "mov"};
            boolean bl = false;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[1])) continue;
                bl = true;
            }
            if (bl) {
                return stringArray[1] + ":" + stringArray[0] + "." + stringArray[1];
            }
            return string2;
        }
        catch (Exception exception) {
            return "mp4:" + string2 + ".mp4";
        }
    }

    public void setUserHTTPHeaders(String string) {
        this.userHTTPHeaders = string;
    }

    public void setDefaultOutput(String string) {
        this.defaultOutput = string;
    }

    public void onBind(IVHost iVHost, HostPort hostPort) {
        super.onBind(iVHost, hostPort);
        String string = Server.getInstance().getProperties().getPropertyStr("loadBalanceHTTPOutputClasses", null);
        string = Server.getInstance().getProperties().getPropertyStr("loadbalanceHTTPOutputClasses", string);
        if (string == null) {
            string = iVHost.getProperties().getPropertyStr("loadBalanceHTTPOutputClasses", null);
            string = iVHost.getProperties().getPropertyStr("loadbalanceHTTPOutputClasses", string);
        }
        if (string != null) {
            Map map = HTTPUtils.expandHTTPHeadersStr((String)string);
            for (Object object : map.keySet()) {
                this.loadHTTPExtensions.add((String)object);
            }
        }
        for (String string2 : this.loadHTTPExtensions) {
            try {
                Object object;
                object = Class.forName(string2);
                ILoadBalancerHTTPExtension iLoadBalancerHTTPExtension = (ILoadBalancerHTTPExtension)((Class)object).newInstance();
                if (iLoadBalancerHTTPExtension != null) {
                    String string3 = iLoadBalancerHTTPExtension.getComponentName().toLowerCase();
                    iLoadBalancerHTTPExtension.setLogger(this.logger);
                    iLoadBalancerHTTPExtension.setDebug(this.debug);
                    this.extensions.put(string3, iLoadBalancerHTTPExtension);
                    continue;
                }
                this.logger.logMessageInfo(CLASS.toString(), "[" + iVHost.getName() + "]: Class not found: " + string2);
            }
            catch (Exception exception) {
                this.logger.logMessageInfo(CLASS.toString(), "[" + iVHost.getName() + "]: Class not found: " + string2);
            }
        }
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object object;
        Object object2;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            String string = iHTTPResponse.getHeader("WWW-Authenticate");
            string = string.replace("Wowza Media Systems", "Wowza Media Systems Load Balancer " + ReleaseInfo.getVersion() + " build " + ReleaseInfo.getBuildNumber());
            iHTTPResponse.setHeader("WWW-Authenticate", string);
            return;
        }
        Map map = iHTTPRequest.getParameterMap();
        String string = null;
        String string2 = null;
        iHTTPRequest.getQueryString();
        if (map.containsKey("type")) {
            string = (String)((List)map.get("type")).get(0);
            string = string.toLowerCase();
        }
        if (string == null) {
            string = this.getURLExtension(iHTTPRequest.getRequestURL());
        }
        if (!this.extensions.containsKey(string)) {
            string = this.defaultOutput;
        }
        if (string != null) {
            if (this.extensions.containsKey(string)) {
                object2 = this.extensions.get(string);
                if (object2.getActive()) {
                    string2 = object2.processHTTPRequest(iVHost, iHTTPRequest, iHTTPResponse, this.getStreamPath(iHTTPRequest), this.loadBalanceServer);
                    if (this.userHTTPHeaders != null) {
                        object = HTTPUtils.expandHTTPHeadersStr((String)this.userHTTPHeaders);
                        for (String string3 : object.keySet()) {
                            iHTTPResponse.setHeader(string3, (String)object.get(string3));
                        }
                    }
                    iHTTPResponse.setHeader("Connection", "close");
                } else {
                    string2 = "Type not available";
                }
            } else {
                string2 = "Type not available";
            }
        } else {
            string2 = "Type not specified";
        }
        try {
            if (string2 != null && string2.length() > 0) {
                object2 = iHTTPResponse.getOutputStream();
                object = string2.getBytes();
                ((OutputStream)object2).write((byte[])object);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("LoadBalancerHTTPProvider: " + exception);
        }
    }

    public String getURLExtension(String string) {
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "getURLExtension URL Request was " + string);
        }
        String[] stringArray = string.split("/");
        String string2 = stringArray[stringArray.length - 1];
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "LastPart is  " + string2);
        }
        if (string2.contains("?")) {
            try {
                string2 = string2.split("\\?")[0];
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "LastPart is  " + string2);
        }
        if (string2 != null && string2.contains(".")) {
            try {
                string2 = string2.split("\\.")[1];
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Output is  " + string2);
        }
        return string2;
    }

    public void setLoadBalancerServerObject(ILoadBalancerServer iLoadBalancerServer) {
        this.loadBalanceServer = iLoadBalancerServer;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getStreamPath(IHTTPRequest iHTTPRequest) {
        String string = iHTTPRequest.getRequestURL();
        String string2 = string.split("/")[0];
        return string.replace(string2, "");
    }
}

