/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPSMIL
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPSMIL> CLASS = LoadBalancerHTTPSMIL.class;
    private final String COMPONENT_NAME = "SMIL";
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "SMIL";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        Map map = iHTTPRequest.getParameterMap();
        String string2 = iHTTPRequest.getRequestURL();
        String string3 = iHTTPRequest.getQueryString();
        Object object = "";
        String string4 = "rtmp";
        String string5 = "";
        String string6 = "";
        String string7 = iHTTPRequest.getRemoteAddr();
        if (map.containsKey("IP")) {
            try {
                string7 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string7 = "INVALID";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string7);
        hashMap.put("ClientStream", string);
        hashMap.put("ClientQueryString", string3);
        hashMap.put("ClientScheme", iHTTPRequest.isSecure() ? "true" : "false");
        hashMap.put("ClientPort", String.valueOf(iHTTPRequest.getServerPort()));
        if (map.containsKey("scheme")) {
            string4 = (String)((List)map.get("scheme")).get(0);
        }
        if (map.containsKey("assets")) {
            string5 = (String)((List)map.get("assets")).get(0);
        }
        if (map.containsKey("bitrates")) {
            string6 = (String)((List)map.get("bitrates")).get(0);
        }
        if (string2.endsWith(".xml")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        String[] stringArray = LoadBalancerHTTPProvider.getLoadBalancedPath(string2);
        ILoadBalancerServerClient iLoadBalancerServerClient = iLoadBalancerServer.processServerDataExtensions(hashMap);
        if (iLoadBalancerServerClient != null) {
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        string3 = LoadBalancerHTTPProvider.removeKnownParameters(string3);
        object = (String)object + "<?xml version=\"1.0\"?>\n";
        object = (String)object + "<smil>\n";
        object = (String)object + "<head>\n";
        object = (String)object + "<meta base=\"" + string4 + "://" + iLoadBalancerServerClient.getClientHost() + "/" + stringArray[0] + "\" />\n";
        object = (String)object + "</head>\n";
        object = (String)object + "<body>\n";
        object = (String)object + "<switch>\n";
        if (string5.length() != 0) {
            String[] stringArray2 = new String[]{};
            try {
                stringArray2 = string5.split(",");
            }
            catch (Exception exception) {
                stringArray2[0] = string5;
            }
            String[] stringArray3 = new String[]{};
            try {
                stringArray3 = string6.split(",");
            }
            catch (Exception exception) {
                stringArray3[0] = string6;
            }
            if (stringArray2.length == stringArray3.length) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = (String)object + "<video src=\"" + stringArray[1] + stringArray2[i];
                    object = (String)object + string3;
                    object = (String)object + "\" system-bitrate=\"" + stringArray3[i] + "\"/>\n";
                }
            }
        } else {
            object = (String)object + "<video src=\"" + stringArray[1] + stringArray[2];
            object = (String)object + string3;
            object = (String)object + "\" />\n";
        }
        object = (String)object + "</switch>\n";
        object = (String)object + "</body>\n";
        object = (String)object + "</smil>\n";
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "SMIL Output: " + (String)object);
        }
        return object;
    }
}

