/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class LoadBalancerHTTPServer
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPServer> CLASS = LoadBalancerHTTPServer.class;
    private final String COMPONENT_NAME = "serverinfo";
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "serverinfo";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        String string2 = "";
        String string3 = "";
        Object object = "";
        Map map = iHTTPRequest.getParameterMap();
        String string4 = iHTTPRequest.getRemoteAddr();
        if (map.containsKey("IP")) {
            try {
                string4 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string4 = "INVALID";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string4);
        hashMap.put("ClientStream", string);
        HashMap<String, ILoadBalancerServerClient> hashMap2 = iLoadBalancerServer.getClients(true);
        if (map.containsKey("command")) {
            string2 = (String)((List)map.get("command")).get(0);
        }
        if (map.containsKey("client")) {
            string3 = (String)((List)map.get("client")).get(0);
        }
        if (string2.equalsIgnoreCase("pauseclient") && hashMap2.containsKey(string3)) {
            ILoadBalancerServerClient iLoadBalancerServerClient = hashMap2.get(string3);
            if (iLoadBalancerServerClient.getState().equalsIgnoreCase("pause")) {
                this.logger.logMessageInfo(CLASS.toString(), "Client: UnPause: " + hashMap2.get(string3).getAttribute("Client-ClientName"));
                hashMap2.get(string3).setState("OK");
            } else {
                this.logger.logMessageInfo(CLASS.toString(), "Client: Pause: " + hashMap2.get(string3).getAttribute("Client-ClientName"));
                hashMap2.get(string3).setState("pause");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            iHTTPResponse.setHeader("Location", iHTTPRequest.getRequestURL());
            iHTTPResponse.setResponseCode(302);
            return null;
        }
        if (string2.equalsIgnoreCase("removeclient") && hashMap2.containsKey(string3)) {
            ILoadBalancerServerClient iLoadBalancerServerClient = hashMap2.get(string3);
            if (iLoadBalancerServerClient.getState().equalsIgnoreCase("OK")) {
                this.logger.logMessageInfo(CLASS.toString(), "Client: Stopped: " + hashMap2.get(string3).getAttribute("Client-ClientName"));
                hashMap2.get(string3).setState("STOP");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            iHTTPResponse.setHeader("Location", iHTTPRequest.getRequestURL());
            iHTTPResponse.setResponseCode(302);
            return null;
        }
        Iterator<String> iterator = iLoadBalancerServer.getServerDecisionList().iterator();
        object = "<title>" + iHTTPRequest.getRequestURI() + "</title>\n";
        object = (String)object + "<br />\n";
        object = (String)object + "<h2>Decisions enabled : ";
        Object object2 = "";
        while (iterator.hasNext()) {
            object2 = (String)object2 + iterator.next() + ",";
        }
        if (((String)object2).length() > 0) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        object = (String)object + (String)object2;
        object = (String)object + "</h2><br />\n";
        object = (String)object + "<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n";
        object = (String)object + "<tr align=\"center\">\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Reference/State</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Host/IP</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">LastUpdate</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Conn/Limit</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Bandwidth/Limit</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Geo Enabled</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">State</td>\n";
        object = (String)object + "<td bgcolor=\"#B0B0B0\">Action</td>\n";
        object = (String)object + "</tr>\n";
        if (hashMap2.keySet().size() > 0) {
            for (String string5 : hashMap2.keySet()) {
                object = (String)object + "<tr align=\"center\">\n";
                object = (String)object + "<td>" + string5 + "/" + hashMap2.get(string5).getAttribute("Client-ClientName") + "</td>\n";
                object = (String)object + "<td>" + hashMap2.get(string5).getClientHost() + "</td>\n";
                Date date = new Date(hashMap2.get(string5).getLastUpdate() * 1000L);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                simpleDateFormat.setTimeZone(TimeZone.getDefault());
                String string6 = simpleDateFormat.format(date);
                object = (String)object + "<td>" + string6 + "</td>\n";
                String string7 = "NA";
                String string8 = "NA";
                if (hashMap2.get(string5).getAttributes().containsKey("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount")) {
                    string7 = hashMap2.get(string5).getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount");
                    string8 = hashMap2.get(string5).getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionLimit");
                }
                object = (String)object + "<td>" + string7 + "/" + string8 + "</td>\n";
                String string9 = "NA";
                String string10 = "NA";
                if (hashMap2.get(string5).getAttributes().containsKey("ClientExtensionBandwidth-loadbalanceClientBandwidth")) {
                    string9 = hashMap2.get(string5).getAttribute("ClientExtensionBandwidth-loadbalanceClientBandwidth");
                    string10 = hashMap2.get(string5).getAttribute("ClientExtensionBandwidth-loadbalanceClientBandwidthLimit");
                }
                object = (String)object + "<td>" + string9 + "/" + string10 + "kbps</td>\n";
                String string11 = "No";
                if (hashMap2.get(string5).getAttributes().containsKey("ClientExtensionCountry-loadbalanceClientCountryList")) {
                    string11 = "Yes";
                }
                object = (String)object + "<td>" + string11 + "</td>\n";
                String string12 = hashMap2.get(string5).getState();
                object = (String)object + "<td>" + string12.substring(0, 1).toUpperCase() + string12.substring(1) + "</td>\n";
                object = (String)object + "<td>\n";
                object = (String)object + "<form action=\"" + iHTTPRequest.getRequestURI() + "\" method=\"GET\">\n";
                object = (String)object + "<input type=\"hidden\" name=\"client\" value=\"" + string5 + "\">\n";
                object = (String)object + "<input type=\"hidden\" name=\"command\" value=\"removeclient\">\n";
                object = (String)object + "<input type=\"submit\" value=\"Remove Client\">\n";
                object = (String)object + "</form>\n";
                object = (String)object + "<form action=\"" + iHTTPRequest.getRequestURI() + "\" method=\"GET\">\n";
                object = (String)object + "<input type=\"hidden\" name=\"client\" value=\"" + string5 + "\">\n";
                object = (String)object + "<input type=\"hidden\" name=\"command\" value=\"pauseclient\">\n";
                object = string12.equalsIgnoreCase("pause") ? (String)object + "<input type=\"submit\" value=\"UnPause Client\">\n" : (String)object + "<input type=\"submit\" value=\"Pause Client\">\n";
                object = (String)object + "</form>\n";
                object = (String)object + "</td>\n";
                object = (String)object + "</tr>\n";
            }
        } else {
            object = (String)object + "<tr align=\"center\"><td colspan=\"8\">No Active Clients</td></tr>\n";
        }
        return object;
    }
}

