/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.listeners;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClient;
import com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerVHostSetup;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.ServerNotifyBase;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHostSingleton;

public class ServerListener
extends ServerNotifyBase {
    private static final Class<ServerListener> CLASS = ServerListener.class;
    private static ILoadBalancerServer loadbalancerServer = null;
    private ILoadBalancerClient client = null;
    private Logger logger = null;
    private String loadBalancerType = "";
    private String redirectIP = "*";
    private String redirectPort = "1935";
    private String redirectPath = "redirect";
    private String listenIP = "*";
    private String listenPort = "1935";
    private String commsPath = "loadbalancerinterface";
    private String infoIP = "*";
    private String infoPort = "1935";
    private String infoPath = "loadbalanceinfo";
    private String configVHostName = "_defaultVHost_";
    private String appNames = "redirect";
    private String decisionOrder = "None Yet";
    private boolean loadBalanceDebug = false;
    private String serverKey = "";
    private boolean debugHTTPComms = false;
    private boolean debugHTTPExtension = false;
    private String authenticationMethod = "admin-basic";
    private String passwordEncodingScheme;

    public static ILoadBalancerServer getLoadBalancerServer() {
        return loadbalancerServer;
    }

    public void onServerCreate(IServer iServer) {
        if (this.logger == null) {
            this.logger = new Logger(WMSLoggerFactory.getLogger(CLASS));
        }
        WMSProperties wMSProperties = iServer.getProperties();
        this.authenticationMethod = wMSProperties.getPropertyStr("loadbalanceAdminAuthenticationMethod", this.authenticationMethod);
        this.passwordEncodingScheme = wMSProperties.getPropertyStr("loadbalanceAdminPasswordEncodingScheme", this.passwordEncodingScheme);
        this.listenIP = wMSProperties.getPropertyString(this.listenIP, new String[]{"loadbalanceServerListenIP", "loadbalanceServerIP"});
        this.listenPort = wMSProperties.getPropertyString(this.listenPort, new String[]{"loadbalanceServerListenPort", "loadbalanceServerPort"});
        this.commsPath = wMSProperties.getPropertyString(this.commsPath, new String[]{"loadbalanceServerListenPath", "loadbalanceServerPath"});
        this.redirectIP = wMSProperties.getPropertyStr("loadbalanceServerRedirectIP", this.listenIP);
        this.redirectPort = wMSProperties.getPropertyStr("loadbalanceServerRedirectPort", this.listenPort);
        this.redirectPath = wMSProperties.getPropertyString(this.redirectPath, new String[]{"loadbalanceServerRedirectPath", "loadbalanceServerListenRedirectPath"});
        this.infoIP = wMSProperties.getPropertyStr("loadbalanceServerInfoIP", this.listenIP);
        this.infoPort = wMSProperties.getPropertyStr("loadbalanceServerInfoPort", this.listenPort);
        this.infoPath = wMSProperties.getPropertyString(this.infoPath, new String[]{"loadbalanceServerInfoPath", "loadbalanceServerListenInfoPath"});
        this.configVHostName = wMSProperties.getPropertyStr("loadbalanceServerListenVHostName", this.configVHostName);
        this.debugHTTPComms = wMSProperties.getPropertyBoolean("loadbalanceDebugClientCommunications", this.debugHTTPComms);
        this.debugHTTPExtension = wMSProperties.getPropertyBoolean("loadbalanceDebugHTTPExtensions", this.debugHTTPExtension);
        this.loadBalancerType = wMSProperties.getPropertyStr("loadbalanceType", this.loadBalancerType);
        this.loadBalancerType = wMSProperties.getPropertyStr("loadbalanceServerType", this.loadBalancerType);
        this.decisionOrder = wMSProperties.getPropertyStr("loadbalanceServerDecisionOrder", this.decisionOrder);
        this.appNames = wMSProperties.getPropertyStr("loadbalanceServerListenApplicationNames", this.appNames);
        this.loadBalanceDebug = wMSProperties.getPropertyBoolean("loadbalanceDebug", this.loadBalanceDebug);
        this.serverKey = wMSProperties.getPropertyStr("loadbalanceKey", this.serverKey);
        if (this.loadBalancerType.contains("Server")) {
            loadbalancerServer = new LoadBalancerServer();
            loadbalancerServer.setLogger(this.logger);
            loadbalancerServer.setDebug(this.loadBalanceDebug);
            loadbalancerServer.init(wMSProperties, null);
            if (loadbalancerServer.getActive()) {
                LoadBalancerServerVHostSetup loadBalancerServerVHostSetup = new LoadBalancerServerVHostSetup();
                loadBalancerServerVHostSetup.setAuthenticationMethod(this.authenticationMethod);
                loadBalancerServerVHostSetup.setPasswordEncodingScheme(this.passwordEncodingScheme);
                loadBalancerServerVHostSetup.setVHostName(this.configVHostName);
                loadBalancerServerVHostSetup.setCommsPort(this.listenPort);
                loadBalancerServerVHostSetup.setCommsPath(this.commsPath);
                loadBalancerServerVHostSetup.setCommsIP(this.listenIP);
                loadBalancerServerVHostSetup.setLoadBalancerServerObject(loadbalancerServer);
                loadBalancerServerVHostSetup.setDebug(this.debugHTTPComms);
                loadBalancerServerVHostSetup.setDebugHTTPProvider(this.debugHTTPExtension);
                loadBalancerServerVHostSetup.setLogger(this.logger);
                loadBalancerServerVHostSetup.setRedirectIp(this.redirectIP);
                loadBalancerServerVHostSetup.setRedirectPort(this.redirectPort);
                loadBalancerServerVHostSetup.setRedirectPath(this.redirectPath);
                loadBalancerServerVHostSetup.setInfoIp(this.infoIP);
                loadBalancerServerVHostSetup.setInfoPort(this.infoPort);
                loadBalancerServerVHostSetup.setInfoPath(this.infoPath);
                loadBalancerServerVHostSetup.setApplicationNames(this.appNames);
                VHostSingleton.addVHostListener((IVHostNotify)loadBalancerServerVHostSetup);
                ((Thread)((Object)loadbalancerServer)).setDaemon(true);
                ((Thread)((Object)loadbalancerServer)).start();
            }
        }
    }

    public void onServerInit(IServer iServer) {
        if (this.logger == null) {
            this.logger = new Logger(WMSLoggerFactory.getLogger(CLASS));
        }
        this.logger.logMessageInfo(CLASS.toString(), "onServerInit() Version: " + ReleaseInfo.getVersion() + " Build " + ReleaseInfo.getBuildNumber() + " Start");
        this.logger.logMessageInfo(CLASS.toString(), "onServerInit() Type is '" + this.loadBalancerType + "'");
        if (!this.loadBalancerType.contains("Client") && !this.loadBalancerType.contains("Server")) {
            this.logger.logMessageInfo(CLASS.toString(), "onServerInit() No Type Defined, not starting");
        }
        if (this.loadBalancerType.contains("Client")) {
            this.client = new LoadBalancerClient();
            this.client.setLogger(this.logger);
            this.client.setDebug(this.loadBalanceDebug);
            this.client.init(iServer.getProperties(), iServer, null);
            ((Thread)((Object)this.client)).setDaemon(true);
            ((Thread)((Object)this.client)).start();
        }
        if (this.loadBalancerType.contains("Server")) {
            this.logger.logMessageInfo(CLASS.toString(), "onServerInit() Decisions set: " + this.decisionOrder);
            this.logger.logMessageInfo(CLASS.toString(), "onServerInit() ApplicationNames for redirection: " + this.appNames);
        }
    }

    public void onServerConfigLoaded(IServer iServer) {
        if (this.logger == null) {
            this.logger = new Logger(WMSLoggerFactory.getLogger(CLASS));
        }
    }
}

