/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.listeners.ServerListener;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.Server;
import com.wowza.wms.util.SecurityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Deprecated(forRemoval=true)
public class ClientConnections
extends ModuleBase {
    private static final String CLASSNAME = "ClientConnections";
    private static final Class<ClientConnections> CLASS = ClientConnections.class;
    private final WMSLogger logger = WMSLoggerFactory.getLogger(CLASS);
    private ILoadBalancerServer loadBalancerServer = null;
    private String validFlashVersionsStr = "Wirecast/|FME/|FMLE/|Wowza GoCoder*|Lavf/|UA Teradek/|KulaByte/|HaivisionKB/|VidBlaster/|XSplit/|PESA|makitoX/|Elemental Live*";
    private List<String> validFlashVersions = new ArrayList<String>();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.validFlashVersionsStr = Server.getInstance().getProperties().getPropertyStr("loadbalanceServerIgnoreClients", this.validFlashVersionsStr);
        this.validFlashVersions = SecurityUtils.parseValidFlashStrings((String)this.validFlashVersionsStr);
        this.logger.info("loadbalancer: Starting LoadBalancer Redirector for version " + ReleaseInfo.getVersion());
        this.logger.info(String.format("loadbalancer: %s.onAppStart[%s]: Publish: IgnoredClientTypes: %s:%s", CLASSNAME, iApplicationInstance.getContextStr(), "securityPublishValidEncoders", this.validFlashVersionsStr));
        this.loadBalancerServer = ServerListener.getLoadBalancerServer();
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
    }

    public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino) {
        hTTPStreamerSessionCupertino.rejectSession();
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        if (rTPSession.getProperties().getPropertyDouble("connectliveRepeaterCapabilities", 0.0) == 1.0 && rTPSession.getProperties().getPropertyStr("connectpageUrl") == null && rTPSession.getProperties().getPropertyStr("connectflashVer").equals("WIN 10,0,12,36") && rTPSession.getProperties().getPropertyStr("connectswfUrl").equals("WowzaProLiveRepeater")) {
            return;
        }
        if (this.loadBalancerServer == null) {
            this.logger.info("loadbalancer: Load Balancer Not Running (server), connection refused.");
            this.logger.info("loadbalancer: This module should only be entered on the load balancer, not the clients.");
            rTPSession.rejectSession();
            rTPSession.shutdown();
        }
        if (this.loadBalancerServer.getServerDecisionList().size() == 0) {
            this.logger.info("loadbalancer: No decision can be made: Decision list not set.");
            this.logger.info("loadbalancer: No redirection performed.");
            return;
        }
        String string = rTPSession.getUri();
        Object object = rTPSession.getQueryStr();
        string = string.replace("rtsp://", "");
        String[] stringArray = this.getLoadBalancedPath(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", rTPSession.getIp());
        hashMap.put("ClientStream", stringArray[1]);
        hashMap.put("ClientQueryString", (String)object);
        ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancerServer.processServerDataExtensions(hashMap);
        if (iLoadBalancerServerClient == null) {
            this.logger.info("loadbalancer: No load balancing clients connected, no redirection");
            rTPSession.shutdown();
            rTPSession.rejectSession();
            return;
        }
        String string2 = "rtsp";
        if (iLoadBalancerServerClient.isSecure()) {
            string2 = "rtsps";
        }
        String string3 = string2 + "://" + iLoadBalancerServerClient.getClientHost() + "/" + stringArray[1] + "/" + stringArray[2];
        object = object != null ? (rTPSession.getQueryStr().length() == 0 ? "" : "?" + rTPSession.getQueryStr()) : "";
        string3 = string3 + (String)object;
        try {
            rTPSession.redirectSession(string3, 301);
            rTPSession.shutdown();
        }
        catch (Exception exception) {
            this.logger.info("loadbalancer: RTSP Redirect Exception: " + exception);
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (iClient == null) {
            return;
        }
        if (iClient.getProperties().getPropertyDouble("connectliveRepeaterCapabilities", 0.0) == 1.0 && iClient.getProperties().getPropertyStr("connectpageUrl") == null && iClient.getProperties().getPropertyStr("connectflashVer").equals("WIN 10,0,12,36") && iClient.getProperties().getPropertyStr("connectswfUrl").equals("WowzaProLiveRepeater")) {
            return;
        }
        if (SecurityUtils.isValidFlashVersion((String)iClient.getFlashVer(), this.validFlashVersions)) {
            this.logger.info("loadbalancer: No redirection: Client type match: " + this.validFlashVersionsStr);
            this.logger.info("loadbalancer: Client: " + iClient.getFlashVer());
            this.invokePrevious(iClient, requestFunction, aMFDataList);
            return;
        }
        if (this.loadBalancerServer == null) {
            this.logger.info("loadbalancer: Load Balancer Not Running (server): Connection refused.");
            this.logger.info("loadbalancer: This module should only be entered on the load balancer, not the clients.");
            iClient.rejectConnection();
            iClient.shutdownClient();
        }
        if (this.loadBalancerServer.getServerDecisionList().size() == 0) {
            this.logger.info("loadbalancer: No decision can be made: Decision list not set.");
            this.logger.info("loadbalancer: No redirection performed.");
            this.invokePrevious(iClient, requestFunction, aMFDataList);
            return;
        }
        String string = iClient.getUri();
        Object object = iClient.getQueryStr();
        String string2 = "rtmp";
        if (string.startsWith("rtmpe://")) {
            string2 = "rtmpe";
        }
        if (string.startsWith("rtmps://")) {
            string2 = "rtmps";
        }
        string = string.replace(string2 + "://", "");
        String[] stringArray = this.getLoadBalancedPath(string);
        stringArray[1] = stringArray[1] + "/";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", iClient.getIp());
        hashMap.put("ClientStream", stringArray[1]);
        hashMap.put("ClientQueryString", (String)object);
        ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancerServer.processServerDataExtensions(hashMap);
        if (iLoadBalancerServerClient == null) {
            this.logger.info("loadbalancer: No load balancing clients connected, no redirection");
            iClient.shutdownClient();
            iClient.rejectConnection();
            return;
        }
        Object object2 = iLoadBalancerServerClient.getClientHost() + "/" + stringArray[1] + stringArray[2];
        object2 = ((String)object2).replace("//", "/");
        object2 = string2 + "://" + (String)object2;
        object = object != null ? (iClient.getQueryStr().length() == 0 ? "" : "?" + iClient.getQueryStr()) : "";
        object2 = (String)object2 + (String)object;
        try {
            iClient.redirectConnection((String)object2);
        }
        catch (Exception exception) {
            this.logger.info("loadbalancer: RTMP Redirect Exception: " + exception);
        }
    }

    public void onConnectAccept(IClient iClient) {
    }

    public void onConnectReject(IClient iClient) {
    }

    public void onDisconnect(IClient iClient) {
    }

    public String getLoadBalancedDomainName(String string) {
        String string2 = "";
        try {
            string2 = string.split("/")[2];
        }
        catch (Exception exception) {
            return "";
        }
        int n = string.indexOf(".");
        try {
            string2 = string.substring(n, string.length() - n);
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    public String[] getLoadBalancedPath(String string) {
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = string.split("/");
        }
        catch (Exception exception) {
            stringArray2[0] = string;
        }
        String string2 = null;
        Object object = "";
        if (stringArray2.length < 2) {
            return stringArray2;
        }
        string2 = stringArray2[stringArray2.length - 1];
        for (int i = 2; i < stringArray2.length - 1; ++i) {
            object = (String)object + stringArray2[i] + "/";
        }
        if (((String)object).length() > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        stringArray[0] = stringArray2[1];
        stringArray[1] = object;
        stringArray[2] = this.transformFormatFile(string2);
        return stringArray;
    }

    private String transformFormatFile(String string) {
        if (string.endsWith("flv")) {
            return string;
        }
        try {
            String[] stringArray = string.split("\\.");
            return stringArray[0] + "." + stringArray[1];
        }
        catch (Exception exception) {
            return string;
        }
    }
}

