/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.module;

import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.listeners.ServerListener;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.Server;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModuleLoadBalancerRedirect
extends ModuleBase {
    private static final Class<ModuleLoadBalancerRedirect> CLASS = ModuleLoadBalancerRedirect.class;
    private static final String CLASSNAME = CLASS.getSimpleName();
    private final ILoadBalancerServer loadBalancer = ServerListener.getLoadBalancerServer();
    private IApplicationInstance appInstance;
    private WMSLogger logger;
    private String domainNamePattern = ".*";
    private boolean redirectPassThrough = false;
    private boolean loadbalancerIsClient = false;
    private String localHostName;
    private boolean debugLog = false;
    private AtomicBoolean logMisConfiguration = new AtomicBoolean(true);

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = ModuleLoadBalancerRedirect.getLogger(CLASS, (IApplicationInstance)iApplicationInstance);
        WMSProperties wMSProperties = Server.getInstance().getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.domainNamePattern = wMSProperties2.getPropertyStr("loadbalanceDomainNamePattern", wMSProperties.getPropertyStr("loadbalanceDomainNamePattern", this.domainNamePattern));
        this.localHostName = wMSProperties.getPropertyStr("loadbalanceClientForceIP", this.localHostName);
        this.redirectPassThrough = wMSProperties2.getPropertyBoolean("loadbalanceRedirectPassThrough", wMSProperties.getPropertyBoolean("loadbalanceRedirectPassThrough", this.redirectPassThrough));
        this.loadbalancerIsClient = wMSProperties.getPropertyStr("loadbalanceType", "Server").toLowerCase().contains("client");
        this.debugLog = wMSProperties2.getPropertyBoolean("loadbalanceDebugRedirect", wMSProperties.getPropertyBoolean("loadbalanceDebugRedirect", this.debugLog));
        this.logger.info(String.format("%s.onAppStart [%s] version: %s, domainNamePattern: %s, localHostname: %s, redirectPassThrough: %b, debugRedirects: %b", CLASSNAME, iApplicationInstance.getContextStr(), ReleaseInfo.getVersion(), this.domainNamePattern, this.localHostName, this.redirectPassThrough, this.debugLog));
        if (this.loadBalancer == null) {
            this.logger.warn("%s.onAppStart [%s] loadBalancer not running. rejecting loadbalancer requests");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        if (this.debugLog) {
            this.logger.info(String.format("%s.onHTTPSessionCreate [%s] request uri: %s, queryStr: %s, serverName: %s", CLASSNAME, this.appInstance.getContextStr(), iHTTPStreamerSession.getUri(), iHTTPStreamerSession.getQueryStr(), iHTTPStreamerSession.getServerIp()));
        }
        if (!iHTTPStreamerSession.getServerIp().matches(this.domainNamePattern)) {
            return;
        }
        try {
            if (this.loadBalancer == null) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onHTTPSessionCreate [%s] loadbalancer not running. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                iHTTPStreamerSession.rejectSession();
                return;
            }
            if (this.redirectPassThrough && this.loadbalancerIsClient && (StringUtils.isEmpty((String)this.localHostName) || this.localHostName.matches(this.domainNamePattern))) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onHTTPSessionCreate [%s] loadbalancer not configured correctly for pass through. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                iHTTPStreamerSession.rejectSession();
                return;
            }
            String string = iHTTPStreamerSession.getUri();
            String string2 = iHTTPStreamerSession.getQueryStr();
            String[] stringArray = string.split("/(?=[^/]*$)");
            String string3 = stringArray.length == 2 ? stringArray[1] : "";
            String string4 = !this.redirectPassThrough ? stringArray[0].split("/", 2)[1] : stringArray[0];
            Map<String, String> map = this.getParams(iHTTPStreamerSession.getIpAddress(), string4, string2);
            ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancer.processServerDataExtensions(map);
            if (iLoadBalancerServerClient == null) {
                if (this.debugLog) {
                    this.logger.warn(String.format("%s.onHttpSessionCreate [%s] request uri: %s, no load balancer clients available. rejecting request", CLASSNAME, this.appInstance.getContextStr(), iHTTPStreamerSession.getUri()));
                }
                iHTTPStreamerSession.rejectSession();
                return;
            }
            String string5 = iLoadBalancerServerClient.isSecure() ? "https" : "http";
            String string6 = iLoadBalancerServerClient.getClientHost();
            String string7 = String.format("%s://%s/%s%s", string5, string6, String.join((CharSequence)"/", string4, string3), !StringUtils.isEmpty((String)string2) ? "?" + string2 : "");
            iHTTPStreamerSession.redirectSession(string7);
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        catch (Exception exception) {
            this.logger.error(String.format("%s.onHttpSessionCreate [%s] request uri: %s, %s", CLASSNAME, this.appInstance.getContextStr(), iHTTPStreamerSession.getUri(), exception), (Throwable)exception);
            iHTTPStreamerSession.rejectSession();
        }
        finally {
            iHTTPStreamerSession.setDeleteSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRTPSessionCreate(RTPSession rTPSession) {
        if (this.debugLog) {
            this.logger.info(String.format("%s.onRTPSessionCreate [%s] request uri: %s, queryStr: %s, serverName: %s", CLASSNAME, this.appInstance.getContextStr(), rTPSession.getUri(), rTPSession.getQueryStr(), rTPSession.getServerIp()));
        }
        if (!rTPSession.getServerIp().matches(this.domainNamePattern)) {
            return;
        }
        try {
            if (this.loadBalancer == null) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onRTPSessionCreate [%s] loadbalancer not running. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                rTPSession.rejectSession();
                return;
            }
            if (this.redirectPassThrough && (StringUtils.isEmpty((String)this.localHostName) || this.localHostName.matches(this.domainNamePattern))) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onRTPSessionCreate [%s] loadbalancer not configured correctly for pass through. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                rTPSession.rejectSession();
                return;
            }
            String string = rTPSession.getUri();
            String string2 = rTPSession.getQueryStr();
            URI uRI = new URI(string);
            String string3 = this.getAssetPath(uRI);
            Map<String, String> map = this.getParams(rTPSession.getIp(), string3, string2);
            ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancer.processServerDataExtensions(map);
            if (iLoadBalancerServerClient == null) {
                if (this.debugLog) {
                    this.logger.warn(String.format("%s.onHttpSessionCreate [%s] request uri: %s, no load balancer clients available. rejecting request", CLASSNAME, this.appInstance.getContextStr(), rTPSession.getUri()));
                }
                rTPSession.rejectSession();
                return;
            }
            String string4 = iLoadBalancerServerClient.isSecure() ? "rtsps" : "rtsp";
            String string5 = iLoadBalancerServerClient.getClientHost();
            String string6 = String.format("%s://%s/%s%s", string4, string5, string3, !StringUtils.isEmpty((String)string2) ? "?" + string2 : "");
            rTPSession.redirectSession(string6);
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        catch (Exception exception) {
            this.logger.error(String.format("%s.onHttpSessionCreate [%s] request uri: %s, %s", CLASSNAME, this.appInstance.getContextStr(), rTPSession.getUri(), exception), (Throwable)exception);
            rTPSession.rejectSession();
        }
        finally {
            this.appInstance.getVHost().getRTPContext().shutdownRTPSession(rTPSession);
        }
    }

    private String getAssetPath(URI uRI) {
        String string = uRI.getPath().replaceFirst("^/", "");
        return !this.redirectPassThrough ? string.split("/", 2)[1] : string;
    }

    private Map<String, String> getParams(String string, String string2, String string3) {
        return Map.of("ClientIP", string, "ClientStream", string2, "ClientQueryString", string3 != null ? string3 : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        URI uRI;
        String string;
        String string2 = iClient.getQueryStr();
        if (this.debugLog) {
            this.logger.info(String.format("%s.onConnect [%s] request uri: %s, queryStr: %s", CLASSNAME, this.appInstance.getContextStr(), iClient, iClient.getUri(), string2));
        }
        String string3 = string = (uRI = URI.create(iClient.getUri())).getHost() != null ? uRI.getHost() : "";
        if (!string.matches(this.domainNamePattern)) {
            return;
        }
        try {
            if (this.loadBalancer == null) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onConnect [%s] loadbalancer not running. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                iClient.rejectConnection();
                return;
            }
            if (this.redirectPassThrough && (StringUtils.isEmpty((String)this.localHostName) || this.localHostName.matches(this.domainNamePattern))) {
                if (this.logMisConfiguration.getAndSet(false) || this.debugLog) {
                    this.logger.error(String.format("%s.onConnect [%s] loadbalancer not configured correctly for pass through. rejecting loadbalancer requests", CLASSNAME, this.appInstance.getContextStr()));
                }
                iClient.rejectConnection();
                return;
            }
            String string4 = this.getAssetPath(uRI);
            Map<String, String> map = this.getParams(iClient.getIp(), string4, string2);
            ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancer.processServerDataExtensions(map);
            if (iLoadBalancerServerClient == null) {
                if (this.debugLog) {
                    this.logger.warn(String.format("%s.onHttpSessionCreate [%s] request uri: %s, no load balancer clients available. rejecting request", CLASSNAME, this.appInstance.getContextStr(), iClient.getUri()));
                }
                iClient.rejectConnection();
                return;
            }
            String string5 = iLoadBalancerServerClient.isSecure() ? "rtmps" : "rtmp";
            String string6 = iLoadBalancerServerClient.getClientHost();
            String string7 = String.format("%s://%s/%s%s", string5, string6, string4, !StringUtils.isEmpty((String)string2) ? "?" + string2 : "");
            iClient.redirectConnection(string7);
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        catch (Exception exception) {
            this.logger.error(String.format("%s.onHttpSessionCreate [%s] request uri: %s, %s", CLASSNAME, this.appInstance.getContextStr(), iClient.getUri(), exception), (Throwable)exception);
            iClient.rejectConnection();
        }
        finally {
            iClient.setShutdownClient(true);
        }
    }

    private void incrementConnectionCount(ILoadBalancerServerClient iLoadBalancerServerClient) {
        ILoadBalancerServerClient iLoadBalancerServerClient2 = this.loadBalancer.getClients(false).get(iLoadBalancerServerClient.getClientID());
        String string = iLoadBalancerServerClient2.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount");
        if (!StringUtils.isEmpty((String)string)) {
            iLoadBalancerServerClient2.addAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount", String.valueOf(Integer.parseInt(string) + 1));
        }
        System.out.println("count = " + string);
        System.out.println("incremented = " + iLoadBalancerServerClient2.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount"));
    }
}

