/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.HashMap;
import java.util.Map;

public class LoadBalancerServerClient
implements ILoadBalancerServerClient {
    private boolean debug = false;
    private boolean active = false;
    private long lastUpdate = 0L;
    private String lastState = "";
    private String clientID = "";
    private HashMap<String, String> attributes = new HashMap();
    private Logger logger = null;

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public void setClientID(String string) {
        this.clientID = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    @Override
    public boolean getTimeOut() {
        return this.getLastUpdate() > 0L && System.currentTimeMillis() / 1000L - 60L > this.getLastUpdate();
    }

    @Override
    public String getState() {
        return this.lastState;
    }

    @Override
    public void setState(String string) {
        this.lastState = string;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttribute(String string) {
        if (this.attributes != null && this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClient(Map<String, String> map) {
        if (this.attributes != null && map != null) {
            HashMap<String, String> hashMap = this.attributes;
            synchronized (hashMap) {
                this.attributes.clear();
                for (String string : map.keySet()) {
                    this.attributes.put(string, map.get(string));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttribute(String string, String string2) {
        HashMap<String, String> hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientHost() {
        Object object = "";
        String string = "";
        HashMap<String, String> hashMap = this.attributes;
        synchronized (hashMap) {
            object = this.getAttribute("Client-SourceIP");
            string = this.getAttribute("Client-DestinPort");
            if (this.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientForceIP")) {
                object = this.getAttribute("ClientExtensionBaseClientProperties-loadbalanceClientForceIP");
            }
            if (this.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientForcePort")) {
                string = this.getAttribute("ClientExtensionBaseClientProperties-loadbalanceClientForcePort");
            }
            if (string != null && !string.isEmpty()) {
                if (!this.isSecure() && !string.equalsIgnoreCase("80")) {
                    object = (String)object + ":" + string;
                }
                if (this.isSecure() && !string.equalsIgnoreCase("443")) {
                    object = (String)object + ":" + string;
                }
            }
        }
        return object;
    }

    @Override
    public String getScheme() {
        String string = "http";
        if (this.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientForceScheme")) {
            string = this.getAttribute("ClientExtensionBaseClientProperties-loadbalanceClientForceScheme");
        }
        return string;
    }

    @Override
    public boolean isSecure() {
        boolean bl = false;
        String string = this.getScheme();
        if (string.endsWith("s")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void copyServerClient(ILoadBalancerServerClient iLoadBalancerServerClient) {
        HashMap<String, String> hashMap = iLoadBalancerServerClient.getAttributes();
        for (String string : hashMap.keySet()) {
            this.attributes.put(string, hashMap.get(string));
        }
        this.setClientID(iLoadBalancerServerClient.getClientID());
        this.setLogger(iLoadBalancerServerClient.getLogger());
        this.setDebug(iLoadBalancerServerClient.getDebug());
        this.setActive(iLoadBalancerServerClient.getActive());
        this.setLastUpdate(iLoadBalancerServerClient.getLastUpdate());
        this.setState(iLoadBalancerServerClient.getState());
    }
}

