/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.encryption.CommunicationEncryptor;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerCommunication;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LoadBalancerServerCommunication
implements ILoadBalancerServerCommunication {
    private static final Class<LoadBalancerServerCommunication> CLASS = LoadBalancerServerCommunication.class;
    private final Lock lock = new ReentrantLock();
    private Logger logger = null;
    private CommunicationEncryptor communicationEncrypter = null;
    private String serverKey = "";
    private boolean debug = false;
    private boolean active = true;

    @Override
    public boolean init() {
        try {
            this.communicationEncrypter = new CommunicationEncryptor(this.serverKey);
        }
        catch (Exception exception) {
            this.logger.logMessageInfo(CLASS.getName(), "Encryption class not found, not initialising");
            this.active = false;
        }
        return this.active;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> processRequest(IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, String string2) {
        Map<String, String> map;
        if (!this.getActive()) {
            return null;
        }
        try {
            this.lock.lock();
            String string3 = "";
            try {
                string3 = this.communicationEncrypter.decrypt(string);
                if (this.debug) {
                    this.logger.logMessageDebug(CLASS.getName(), "request: " + string3);
                }
            }
            catch (Exception exception) {
                if (this.getDebug()) {
                    this.logger.logMessageDebug(CLASS.getName(), "Decoded request failed exception was " + exception);
                }
                string3 = "";
            }
            map = this.extractDataFromJson(string3);
        }
        finally {
            this.lock.unlock();
        }
        return map;
    }

    private Map<String, String> extractDataFromJson(String string) {
        HashMap<String, String> hashMap = new HashMap();
        try {
            hashMap = (Map)new ObjectMapper().readValue(string, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.logger.logMessageError(CLASS.getSimpleName(), "extractDataFromJson: output: " + string + ", exception: " + jsonProcessingException.getMessage());
        }
        return hashMap;
    }

    @Override
    public String generateResponse(Map<String, String> map) {
        String string = null;
        String string2 = null;
        try {
            string = new ObjectMapper().writeValueAsString(map);
            string2 = this.communicationEncrypter.encrypt(string);
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.logger.logMessageError(CLASS.getName(), "error processing json response");
        }
        if (this.debug) {
            this.logger.logMessageDebug(CLASS.getName(), "server response: " + string);
        }
        return string2;
    }
}

