/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.http.HTTPProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerCommunication;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LoadBalancerServerCommunicationProvider
extends HTTPProvider2Base {
    private static final Class<LoadBalancerServerCommunicationProvider> CLASS = LoadBalancerServerCommunicationProvider.class;
    private boolean debug = false;
    private boolean available = false;
    private ILoadBalancerServer loadBalanceServer = null;
    private ILoadBalancerServerCommunication serverComms = null;
    private Logger logger = null;

    public void onBind(IVHost iVHost, HostPort hostPort) {
        super.onBind(iVHost, hostPort);
        this.serverComms = this.loadBalanceServer.getServerCommunication();
        if (this.getDebug()) {
            this.logger.logMessageInfo(CLASS.getName(), "Server comms object is " + this.serverComms);
        }
        if (this.serverComms != null) {
            this.available = true;
        }
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        String string;
        String string2;
        block20: {
            Map map;
            block19: {
                if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.getName(), "is available '" + this.available + "'");
                }
                if (!this.available) {
                    return;
                }
                string2 = "";
                string = "";
                iHTTPRequest.parseBodyForParams();
                map = iHTTPRequest.getParameterMap();
                try {
                    string2 = (String)Objects.requireNonNull((List)map.get("data"), "data is null").get(0);
                }
                catch (Exception exception) {
                    if (!this.getDebug()) break block19;
                    this.logger.logMessageError(CLASS.getName(), "not received command " + exception);
                    this.logger.logMessageError(CLASS.getName(), "not received command cause: " + exception.getCause());
                }
            }
            try {
                string = (String)Objects.requireNonNull((List)map.get("client"), "client is null").get(0);
            }
            catch (Exception exception) {
                if (!this.getDebug()) break block20;
                this.logger.logMessageError(CLASS.getName(), "noReceivedID " + exception);
                this.logger.logMessageError(CLASS.getName(), "noReceivedID cause: " + exception.getCause());
            }
        }
        if (string2.isEmpty()) {
            this.logger.logMessageError(CLASS.getName(), "received command is no length");
            return;
        }
        String string3 = "";
        Map<String, String> map = this.serverComms.processRequest(iHTTPRequest, iHTTPResponse, string2, string);
        if (map != null) {
            if ((map = this.loadBalanceServer.processClientRequest(iHTTPRequest, map, string)) != null) {
                if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.getName(), "received data: " + map);
                }
                if ((string3 = this.serverComms.generateResponse(map)) == null) {
                    if (this.getDebug()) {
                        this.logger.logMessageInfo(CLASS.getName(), "generateResponse was null");
                    }
                    string3 = "";
                }
            } else if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.getName(), "HTTP processClientRequest receivedData was null");
            }
        } else if (this.getDebug()) {
            this.logger.logMessageInfo(CLASS.getName(), "HTTP processRequest receivedData was null");
        }
        if (this.getDebug()) {
            this.logger.logMessageInfo(CLASS.getName(), "HTTP processRequest sending output");
        }
        try {
            OutputStream outputStream = iHTTPResponse.getOutputStream();
            byte[] byArray = string3.getBytes();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("LoadBalancerServerCommunicationProvider", (Throwable)exception);
        }
    }

    public void setLoadBalancerServerObject(ILoadBalancerServer iLoadBalancerServer) {
        this.loadBalanceServer = iLoadBalancerServer;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

