/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerServerExtensionConnectionCounts
implements ILoadBalancerServerDataExtension {
    private static final Class<LoadBalancerServerExtensionConnectionCounts> CLASS = LoadBalancerServerExtensionConnectionCounts.class;
    private final String COMPONENT_NAME = "Connection";
    private final Comparator<ILoadBalancerServerClient> clientCountComparator = new Comparator<ILoadBalancerServerClient>(){

        @Override
        public int compare(ILoadBalancerServerClient iLoadBalancerServerClient, ILoadBalancerServerClient iLoadBalancerServerClient2) {
            String string;
            long l = 0L;
            long l2 = 0L;
            if (iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount") && (string = iLoadBalancerServerClient.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount")) != null) {
                try {
                    l = Long.valueOf(string);
                }
                catch (Exception exception) {
                    l = 1L;
                }
            }
            if (iLoadBalancerServerClient2.getAttributes().containsKey("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount") && (string = iLoadBalancerServerClient2.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount")) != null) {
                try {
                    l2 = Long.valueOf(string);
                }
                catch (Exception exception) {
                    l2 = 1L;
                }
            }
            int n = (int)l - (int)l2;
            return n;
        }
    };
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;

    @Override
    public void init(WMSProperties wMSProperties) {
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void updateComponent(HashMap<String, String> hashMap) {
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "Connection";
    }

    @Override
    public List<ILoadBalancerServerClient> processClientInformation(List<ILoadBalancerServerClient> list, Map<String, String> map) {
        int n;
        if (!this.getActive()) {
            return list;
        }
        if (list == null) {
            return list;
        }
        ArrayList<ILoadBalancerServerClient> arrayList = new ArrayList<ILoadBalancerServerClient>();
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Starting search");
        }
        long l = 1L;
        long l2 = 0L;
        Collections.sort(list, this.clientCountComparator);
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Client Order After Sort");
            for (n = 0; n < list.size(); ++n) {
                this.logger.logMessageDebug(CLASS.getName(), "Client ID: " + list.get(n).getClientID() + " Name: " + list.get(n).getAttribute("Client-ClientName"));
            }
        }
        for (n = 0; n < list.size(); ++n) {
            ILoadBalancerServerClient iLoadBalancerServerClient = null;
            try {
                iLoadBalancerServerClient = list.get(n);
            }
            catch (Exception exception) {
                continue;
            }
            if (iLoadBalancerServerClient == null) continue;
            if (iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount")) {
                if (!iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionConnectionCounts-loadbalanceClientConnectionLimit")) continue;
                String string = iLoadBalancerServerClient.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionLimit");
                String string2 = iLoadBalancerServerClient.getAttribute("ClientExtensionConnectionCounts-loadbalanceClientConnectionCount");
                if (string != null) {
                    try {
                        l = Long.valueOf(string);
                    }
                    catch (Exception exception) {
                        l = 1L;
                    }
                }
                if (string2 != null) {
                    try {
                        l2 = Long.valueOf(string2);
                    }
                    catch (Exception exception) {
                        l2 = 1L;
                    }
                }
                if (l2 >= l && l != 0L) continue;
                arrayList.add(iLoadBalancerServerClient);
                continue;
            }
            arrayList.add(iLoadBalancerServerClient);
        }
        if (arrayList.size() == 0) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "No Matching Client found");
            }
        } else if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Client Output list after limits checked");
            for (n = 0; n < arrayList.size(); ++n) {
                this.logger.logMessageDebug(CLASS.getName(), "Client ID: " + ((ILoadBalancerServerClient)arrayList.get(n)).getClientID() + " Name: " + ((ILoadBalancerServerClient)arrayList.get(n)).getAttribute("Client-ClientName"));
            }
        }
        return arrayList;
    }
}

