/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.maxmind.geoip.LookupService;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated(forRemoval=true)
public class LoadBalancerServerExtensionMaxMind
implements ILoadBalancerServerDataExtension {
    private static final Class<LoadBalancerServerExtensionMaxMind> CLASS = LoadBalancerServerExtensionMaxMind.class;
    private final String COMPONENT_NAME = "Geographic";
    private LookupService maxMindGeoIPObject = null;
    private String databaseLocation = "{com.wowza.wms.context.ServerConfigHome}/GeoIP.dat";
    private boolean isReady = false;
    private boolean debug = false;
    private boolean active = false;
    private long lastGeoUpdate = 0L;
    private long nextUpdate = 0L;
    private boolean reloadGeo = false;
    private Logger logger = null;

    @Override
    public void init(WMSProperties wMSProperties) {
        this.databaseLocation = wMSProperties.getPropertyStr("loadbalanceServerMaxMindDataFile", this.databaseLocation);
        this.databaseLocation = this.databaseLocation.replace("{com.wowza.wms.context.ServerConfigHome}", Bootstrap.getServerHome((int)2));
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Maxmind GeoIP database location is " + this.databaseLocation);
        }
        try {
            this.loadDatabase();
        }
        catch (Exception exception) {
            this.isReady = false;
        }
    }

    public boolean reloadDatabase() {
        if (this.clearDatabase()) {
            try {
                this.isReady = this.loadDatabase();
            }
            catch (Exception exception) {
                this.isReady = false;
            }
            return this.isReady;
        }
        return false;
    }

    public boolean loadDatabase() throws IOException {
        try {
            this.maxMindGeoIPObject = new LookupService(this.databaseLocation, 1);
            this.isReady = true;
            this.lastGeoUpdate = System.currentTimeMillis() / 1000L;
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "MaxMind Geo Data File failed to load due to " + exception + " using file " + this.databaseLocation);
            }
            this.isReady = false;
            this.maxMindGeoIPObject = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "MaxMind Geo Data File failed to load due to " + noClassDefFoundError + " using file " + this.databaseLocation);
            }
            this.maxMindGeoIPObject = null;
            this.isReady = false;
        }
        return this.isReady;
    }

    public boolean clearDatabase() {
        if (this.maxMindGeoIPObject != null && this.isReady) {
            this.maxMindGeoIPObject.close();
            this.maxMindGeoIPObject = null;
            this.isReady = false;
        }
        return true;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean getReady() {
        return this.isReady;
    }

    @Override
    public void updateComponent(HashMap<String, String> hashMap) {
        if (System.currentTimeMillis() / 1000L > this.nextUpdate) {
            this.nextUpdate = System.currentTimeMillis() / 1000L + 300L;
            File file = new File(this.databaseLocation);
            if (file.exists()) {
                long l = file.lastModified();
                if (this.reloadGeo) {
                    this.reloadDatabase();
                    this.reloadGeo = false;
                }
                if (l != this.lastGeoUpdate) {
                    this.lastGeoUpdate = l;
                    this.reloadGeo = true;
                }
            }
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "Geographic";
    }

    @Override
    public List<ILoadBalancerServerClient> processClientInformation(List<ILoadBalancerServerClient> list, Map<String, String> map) {
        if (!this.getActive()) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Maxmind not active, returning all client sent in");
            }
            return list;
        }
        if (!this.getReady()) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Maxmind not ready, returning all client sent in");
            }
            return list;
        }
        if (list == null) {
            return list;
        }
        String string = "";
        String string2 = map.get("ClientIP");
        try {
            string = this.maxMindGeoIPObject.getCountry(string2).getCode();
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Maxmind return value " + string);
            }
        }
        catch (Exception exception) {
            return list;
        }
        if (string == null) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Country lookup returned null, returning all clients into search");
            }
            return list;
        }
        if (string.length() <= 1) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Country lookup returned " + string + ", - too short -  returning all clients into search");
            }
            return list;
        }
        ArrayList<ILoadBalancerServerClient> arrayList = new ArrayList<ILoadBalancerServerClient>();
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Maxmind starting search");
        }
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> hashMap;
            ILoadBalancerServerClient iLoadBalancerServerClient = null;
            try {
                iLoadBalancerServerClient = list.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (iLoadBalancerServerClient == null || !(hashMap = iLoadBalancerServerClient.getAttributes()).containsKey("ClientExtensionCountry-loadbalanceClientCountryList")) continue;
            String string3 = iLoadBalancerServerClient.getAttribute("ClientExtensionCountry-loadbalanceClientCountryList");
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client " + iLoadBalancerServerClient + " country found " + string3);
            }
            if (!string3.contains(string) && !string3.contains("*")) continue;
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client " + iLoadBalancerServerClient + " country found " + string3 + " matches " + string);
            }
            arrayList.add(iLoadBalancerServerClient);
        }
        return arrayList;
    }
}

