/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerServerExtensionMaxMindGeoIP2City
implements ILoadBalancerServerDataExtension {
    private static final Class<LoadBalancerServerExtensionMaxMindGeoIP2City> CLASS = LoadBalancerServerExtensionMaxMindGeoIP2City.class;
    private final String COMPONENT_NAME = "GeoIP2City";
    private DatabaseReader maxMindGeoIPObject = null;
    private String databaseLocation = "{com.wowza.wms.context.ServerConfigHome}/GeoLite2-City.mmdb";
    private boolean isReady = false;
    private boolean debug = false;
    private boolean active = false;
    private long lastGeoUpdate = 0L;
    private long nextUpdate = 0L;
    private boolean reloadGeo = false;
    private Logger logger = null;

    @Override
    public void init(WMSProperties wMSProperties) {
        this.databaseLocation = wMSProperties.getPropertyStr("loadbalanceServerMaxMindGeoIP2CityFile", this.databaseLocation);
        this.databaseLocation = this.databaseLocation.replace("{com.wowza.wms.context.ServerConfigHome}", Bootstrap.getServerHome((int)2));
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Maxmind GeoIP2 City database location is " + this.databaseLocation);
        }
        try {
            this.loadDatabase();
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Maxmind GeoIP2 City failed with " + exception);
            }
            this.isReady = false;
        }
    }

    public boolean reloadDatabase() {
        if (this.clearDatabase()) {
            try {
                this.isReady = this.loadDatabase();
            }
            catch (Exception exception) {
                this.isReady = false;
            }
            return this.isReady;
        }
        return false;
    }

    public boolean loadDatabase() throws IOException {
        try {
            File file = new File(this.databaseLocation);
            if (file.exists()) {
                this.maxMindGeoIPObject = new DatabaseReader.Builder(file).build();
                this.lastGeoUpdate = file.lastModified();
                this.isReady = true;
                this.reloadGeo = false;
                if (this.getDebug()) {
                    this.logger.logMessageDebug(CLASS.getName(), "MaxMind GeoIP2 City Loaded Data File " + this.databaseLocation);
                }
            }
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "MaxMind GeoIP2 City Data File failed to load due to " + exception + " using file " + this.databaseLocation);
            }
            this.isReady = false;
            this.maxMindGeoIPObject = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "MaxMind GeoIP2 City Data File failed to load due to " + noClassDefFoundError + " using file " + this.databaseLocation);
            }
            this.maxMindGeoIPObject = null;
            this.isReady = false;
        }
        return this.isReady;
    }

    public boolean clearDatabase() {
        if (this.maxMindGeoIPObject != null && this.isReady) {
            try {
                this.maxMindGeoIPObject.close();
            }
            catch (Exception exception) {
                this.logger.logMessageDebug(CLASS.getName(), "MaxMind GeoIP2 City Data File failed to close property due to " + exception + " using file " + this.databaseLocation);
            }
            this.maxMindGeoIPObject = null;
            this.isReady = false;
        }
        return true;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean getReady() {
        return this.isReady;
    }

    @Override
    public void updateComponent(HashMap<String, String> hashMap) {
        if (System.currentTimeMillis() / 1000L > this.nextUpdate) {
            this.nextUpdate = System.currentTimeMillis() / 1000L + 300L;
            File file = new File(this.databaseLocation);
            if (file.exists()) {
                long l = file.lastModified();
                if (this.reloadGeo) {
                    this.reloadDatabase();
                    this.reloadGeo = false;
                }
                if (l != this.lastGeoUpdate) {
                    this.lastGeoUpdate = l;
                    this.reloadGeo = true;
                }
            }
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "GeoIP2City";
    }

    @Override
    public List<ILoadBalancerServerClient> processClientInformation(List<ILoadBalancerServerClient> list, Map<String, String> map) {
        Object object;
        Serializable serializable;
        if (!this.getActive()) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Not active, returning all clients sent in");
            }
            return list;
        }
        if (!this.getReady()) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Not ready, returning all clients sent in");
            }
            return list;
        }
        if (list == null) {
            return list;
        }
        String string = "";
        String string2 = map.get("ClientIP");
        try {
            serializable = InetAddress.getByName(string2);
            CityResponse cityResponse = this.maxMindGeoIPObject.city((InetAddress)serializable);
            object = cityResponse.getCity();
            string = object.getName();
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "City return value " + string);
            }
        }
        catch (Exception exception) {
            return list;
        }
        if (string == null) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "City lookup returned null, returning all clients into search");
            }
            return list;
        }
        if (string.length() <= 1) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "City lookup returned " + string + ", - too short -  returning all clients into search");
            }
            return list;
        }
        serializable = new ArrayList();
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Starting search");
        }
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> hashMap;
            object = null;
            try {
                object = list.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null || !(hashMap = object.getAttributes()).containsKey("ClientExtensionGeoIP2City-loadbalanceClientGeoIP2CityList")) continue;
            String string3 = object.getAttribute("ClientExtensionGeoIP2City-loadbalanceClientGeoIP2CityList");
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client " + (ILoadBalancerServerClient)object + " city found " + string3);
            }
            if (!string3.contains(string) && !string3.contains("*")) continue;
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client " + (ILoadBalancerServerClient)object + " city found " + string3 + " matches " + string);
            }
            serializable.add(object);
        }
        return serializable;
    }
}

