/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerServerExtensionPublishedStream
implements ILoadBalancerServerDataExtension {
    private static final Class<LoadBalancerServerExtensionPublishedStream> CLASS = LoadBalancerServerExtensionPublishedStream.class;
    private final String COMPONENT_NAME = "PublishedStreams";
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private boolean clientsReturnAllIfNotFound = true;
    private boolean clientPrefixedStreamNamePassThrough = true;

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void init(WMSProperties wMSProperties) {
        this.clientsReturnAllIfNotFound = wMSProperties.getPropertyBoolean("loadbalanceServerPublishReturnAllNotFound", this.clientsReturnAllIfNotFound);
        this.clientPrefixedStreamNamePassThrough = wMSProperties.getPropertyBoolean("loadbalanceServerPublishPrefixPassThrough", this.clientPrefixedStreamNamePassThrough);
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "PublishedStreamsServer Initializing");
            this.logger.logMessageDebug(CLASS.getName(), "loadbalanceServerPublishReturnAllNotFound " + this.clientsReturnAllIfNotFound);
            this.logger.logMessageDebug(CLASS.getName(), "loadbalanceServerPublishPrefixPassThrough " + this.clientPrefixedStreamNamePassThrough);
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "PublishedStreams";
    }

    @Override
    public void updateComponent(HashMap<String, String> hashMap) {
    }

    @Override
    public List<ILoadBalancerServerClient> processClientInformation(List<ILoadBalancerServerClient> list, Map<String, String> map) {
        int n;
        if (!this.getActive()) {
            return list;
        }
        String string = null;
        if (map.containsKey("ClientStream")) {
            string = map.get("ClientStream");
        }
        if (string == null) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client stream name not provided, returning all clients");
            }
            return list;
        }
        if (list == null) {
            return list;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.clientPrefixedStreamNamePassThrough && (n = string.indexOf(":")) < 6 && n > -1) {
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Prefix pass through enabled, prefix was :" + string.substring(0, n));
            }
            return list;
        }
        ArrayList<ILoadBalancerServerClient> arrayList = new ArrayList<ILoadBalancerServerClient>();
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Starting search for stream name: " + string);
        }
        for (int i = 0; i < list.size(); ++i) {
            ILoadBalancerServerClient iLoadBalancerServerClient = null;
            try {
                iLoadBalancerServerClient = list.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (iLoadBalancerServerClient == null) continue;
            HashMap<String, String> hashMap = iLoadBalancerServerClient.getAttributes();
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Client found: " + iLoadBalancerServerClient.getAttribute("Client-ClientName"));
                for (String string2 : hashMap.keySet()) {
                    this.logger.logMessageDebug(CLASS.getName(), "Attributes: " + string2 + " value: " + hashMap.get(string2));
                }
            }
            if (!hashMap.containsKey("ClientExtensionPublishedStreams-publishedStreams")) continue;
            String string3 = hashMap.get("ClientExtensionPublishedStreams-publishedStreams");
            if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.toString(), "Client match: '" + (String)string3 + "' match: '" + string + "'");
            }
            if (!string3.toLowerCase().contains(string.toLowerCase())) continue;
            arrayList.add(iLoadBalancerServerClient);
        }
        if (arrayList.size() == 0 && this.clientsReturnAllIfNotFound) {
            if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.toString(), "No matching published streams found, returning all clients, pass through enabled");
            }
            return list;
        }
        return arrayList;
    }
}

