/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.utils;

import com.wowza.wms.plugin.loadbalancer.utils.ILoadBalancerDataRequester;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class LoadBalancerURLRequester
implements ILoadBalancerDataRequester {
    private static final Class<LoadBalancerURLRequester> CLASS = LoadBalancerURLRequester.class;
    public String serverIP = "";
    public String serverPort = "";
    public String serverPath = "";
    public String serverScheme = "http";
    private boolean debug = false;
    private Logger logger = null;
    private int retryCount = 5;
    private long retryTimer = 1000L;

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String string) {
        this.serverIP = string;
    }

    @Override
    public String getServerPath() {
        return this.serverPath;
    }

    @Override
    public void setServerPath(String string) {
        this.serverPath = string;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(String string) {
        this.serverPort = string;
    }

    @Override
    public String getServerScheme() {
        return this.serverScheme;
    }

    @Override
    public void setServerScheme(String string) {
        if (string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"))) {
            this.serverScheme = string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String requestData(String string, String string2, int n) {
        Object object = "";
        int n2 = 0;
        if (this.debug) {
            this.logger.logMessageDebug(CLASS.toString(), "RequestData: Data :'" + string + "'");
            this.logger.logMessageDebug(CLASS.toString(), "RequestData: ID :'" + string2 + "'");
            this.logger.logMessageDebug(CLASS.toString(), "RequestData: timeout :'" + n + "'");
        }
        while (n2 < this.retryCount) {
            block27: {
                int n3 = 0;
                String string3 = this.serverScheme + "://" + this.serverIP + ":" + this.serverPort + "/" + this.serverPath;
                String string4 = "data=" + string + "&client=" + string2;
                byte[] byArray = string4.getBytes(StandardCharsets.UTF_8);
                int n4 = byArray.length;
                if (this.debug) {
                    this.logger.logMessageDebug(CLASS.toString(), "retryMore: " + n2 + ": requestData: " + string3);
                }
                if (n == 0) {
                    n = 3000;
                }
                try {
                    block26: {
                        URL uRL = new URL(string3);
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setConnectTimeout(n);
                        httpURLConnection.setReadTimeout(n);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        httpURLConnection.setRequestProperty("charset", "utf-8");
                        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n4));
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setDoInput(true);
                        httpURLConnection.setUseCaches(false);
                        try (Closeable closeable = new DataOutputStream(httpURLConnection.getOutputStream());){
                            ((FilterOutputStream)closeable).write(byArray);
                        }
                        n3 = httpURLConnection.getResponseCode();
                        if (n3 != 200 && this.debug) {
                            this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: is not 200: " + n3);
                        }
                        if (n3 == 200) {
                            if (this.debug) {
                                this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: Received 200 code");
                            }
                            try {
                                closeable = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                                try {
                                    String string5;
                                    while ((string5 = ((BufferedReader)closeable).readLine()) != null) {
                                        object = (String)object + string5;
                                    }
                                    if (this.debug) {
                                        this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: received is :" + (String)object);
                                    }
                                    Object object2 = object;
                                    return object2;
                                }
                                finally {
                                    ((BufferedReader)closeable).close();
                                }
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                if (this.debug) {
                                    this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: socket exception :" + socketTimeoutException);
                                }
                            }
                            catch (Exception exception) {
                                if (!this.debug) break block26;
                                this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: reader exception :" + exception);
                            }
                        }
                    }
                    Thread.sleep(this.retryTimer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!this.debug) break block27;
                    this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: url exception :" + exception);
                    this.logger.logMessageDebug(CLASS.getName(), "retry: " + n2 + ": requestData: url exception : data received '" + (String)object + "'");
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    @Override
    public long getRetryTime() {
        return this.retryCount;
    }

    @Override
    public void setRetryTime(long l) {
        this.retryTimer = l;
    }
}

