package com.wowza.wse.loadtest.http.helpers;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;

import com.wowza.util.*;
import com.wowza.wms.client.*;
import com.wowza.wms.server.*;
import com.wowza.wms.vhost.*;
import com.wowza.wse.loadtest.configuration.*;
import com.wowza.wse.loadtest.interfaces.*;
import com.wowza.wse.loadtest.logger.*;
import com.wowza.wse.loadtest.module.*;
import com.wowza.wse.loadtest.server.*;

public class Style
{
	private LoadTestLogger log = null;
	private Boolean debug = false;
	private IServer server = null;

	public Style(Boolean debug, IServer server, LoadTestLogger Logger)
	{
		this.debug = debug;
		this.log = Logger;
		this.server = server;
	}

	public String MapErrors(String CompleteErrorList[], HashMap<String, String> FoundErrorList, String input)
	{
		String ErrorMessage = "";
		for (int a = 0; a < CompleteErrorList.length; a++)
		{
			String Name = CompleteErrorList[a].split(":")[0];
			String CSSName = CompleteErrorList[a].split(":")[1];
			if (FoundErrorList.containsKey(Name))
			{
				String Error = FoundErrorList.get(Name);
				String SpecMessage = Error.split(":")[1];
				CSSName = Error.split(":")[0];
				ErrorMessage += "<h2>" + SpecMessage + "</h2>\n";
			}

			if (input.contains(Name))
				input = input.replace(Name, CSSName);
		}

		if (input.contains("ERRORBLOCK"))
			input = input.replace("ERRORBLOCK", ErrorMessage);

		return input;
	}

	public HashMap<String, String> createLoseVars(String PrimaryLocation, String UserAgent)
	{
		HashMap<String, String> LoseVars = new HashMap<String, String>();

		UserAgent = UserAgent.toLowerCase();

		LoseVars.put("JAVASPATH", "/" + PrimaryLocation + "/js");
		LoseVars.put("CSSPATH", "/" + PrimaryLocation + "/css");
		LoseVars.put("IMAGEPATH", "/" + PrimaryLocation + "/images");
		LoseVars.put("REALTIMEIMAGES", "/" + PrimaryLocation + "/realtimeimages");
		LoseVars.put("CONFIG", "/" + PrimaryLocation + "/config");
		LoseVars.put("DYNASIMAGE", "/" + PrimaryLocation + "/dynaimages");
		LoseVars.put("PAGESPATH", "/" + PrimaryLocation + "/pages");
		LoseVars.put("TRIGGERPATH", "/" + PrimaryLocation + "/triggerpath");
		LoseVars.put("APPPATH", "/" + PrimaryLocation + "/apppath");
		LoseVars.put("JWPLAYER", "/" + PrimaryLocation + "/clients/jwplayer/");
		LoseVars.put("FLOWPLAYER", "/" + PrimaryLocation + "/clients/flowplayer/");
		LoseVars.put("BASEPATH", "/" + PrimaryLocation);
		LoseVars.put("USERAGENT", UserAgent);

		return LoseVars;
	}

	public String checkString(Map<String, List<String>> params, String name)
	{
		if (params.containsKey(name))
		{
			if (params.get(name).get(0).equals("null"))
				return "";

			if (params.get(name).get(0).equals("undefined"))
				return "";

			return params.get(name).get(0);
		}
		return "";
	}

	public String StatisticsTransform(String Output, IVHost vhost)
	{
		ConnectionCounter ConnC = vhost.getConnectionCounter();
		IOPerformanceCounter PerfC = vhost.getIoPerformanceCounter();

		Output = Output.replaceFirst("TOTALINBYTES", String.valueOf(PerfC.getMessagesInBytes()));
		Output = Output.replaceFirst("TOTALINBYTESRATE", String.valueOf(((PerfC.getMessagesInBytesRate()) * 8) / 1000));

		Output = Output.replaceFirst("TOTALOUTBYTES", String.valueOf(PerfC.getMessagesOutBytes()));
		Output = Output.replaceFirst("TOTALOUTBYTESRATE", String.valueOf(((PerfC.getMessagesOutBytesRate()) * 8) / 1000));

		Output = Output.replaceFirst("TOTALLOSSBYTES", String.valueOf(PerfC.getMessagesLossBytes()));
		Output = Output.replaceFirst("TOTALLOSSBYTESRATE", String.valueOf(PerfC.getMessagesLossBytesRate()));

		Output = Output.replaceFirst("TOTALCONNACCEPTED", String.valueOf(ConnC.getTotalAccepted()));
		Output = Output.replaceFirst("TOTALCONNREJECTED", String.valueOf(ConnC.getTotalRejected()));

		return Output;
	}

	public String IndexTransform(String Output, String VHostName, IVHost inVHost)
	{
		Output = Output.replace("SETUPINDEX", BuildIndexConfiguration());
		Output = Output.replace("CLIENTINDEX", BuildIndexClient());
		Output = Output.replace("CSSINDEX", BuildIndexCSS());
		return Output;
	}

	public String ReturnFileClass(String ClassFullName)
	{
		String Result = "";

		try
		{
			byte[] buffer = new byte[1024];
			InputStream is = getClass().getResourceAsStream(ClassFullName);
			int amount;
			int currentRead = 0;
			while ((amount = is.read(buffer, currentRead, 1024 - currentRead)) > -1)
			{
				currentRead += amount;
				currentRead = 0;
				String mine = new String(buffer, "UTF-8");
				Result += mine.substring(0, amount);
				Arrays.fill(buffer, (byte)0);
			}
			is.close();
		}
		catch (Exception fileLoadError)
		{
			if (this.debug == true)
			{
				this.log.LogMessage("Exception for loading class is '" + fileLoadError.toString() + "'");
			}
		}

		return Result;
	}

	public String ReturnFileClass(HashMap<String, String> LoseVars, Map<String, List<String>> params, String ClassName, String SkinFile)
	{
		String Result = "";

		if (ClassName.length() > 0)
			ClassName = "/" + ClassName;

		Result = ReturnFileClass(ServerManager.LOADTEST_CONFIGURATION_FILES_PREFIX + ClassName + "/" + SkinFile);

		Result = TransformVars(Result, LoseVars, params, this.log);
		return Result;
	}

	public void ReturnLogoFromClass(String VHost, OutputStream out, boolean Skinnable, String ClassName, String SkinFile)
	{
		String ClassFullName = ServerManager.LOADTEST_CONFIGURATION_FILES_PREFIX + "/" + ClassName + "/" + SkinFile;
		try
		{
			int numRead = 0;
			byte[] buffer = new byte[1024];
			InputStream is = getClass().getResourceAsStream(ClassFullName);
			while ((numRead = is.read(buffer, 0, 1024)) > 0)
				out.write(buffer, 0, numRead);
		}
		catch (Exception e)
		{
			if (this.debug == true)
				this.log.LogMessage("Exception when trying to load class " + ClassFullName);
		}

	}

	public String FindOption(String[][] Map, String name)
	{
		for (int a = 0; a < Map.length; a++)
		{
			if (Map[a][0].equals(name))
				return Map[a][1];
		}
		return "";
	}

	public String FindOptionHashMap(HashMap<String, String> Map, String name)
	{
		if (Map.containsKey(name))
			return Map.get(name);

		return "";
	}

	public HashMap<String, String> ReturnClientTypes()
	{
		HashMap<String, String> Clients = new HashMap<String, String>();
		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();
		Iterator<String> IManagers = Managers.keySet().iterator();
		while (IManagers.hasNext())
		{
			String Manager = IManagers.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			Clients.put(ThisManager.getPrivateManagerName(), ThisManager.getPublicManagerName());
		}

		return Clients;
	}

	public String[][] ReturnStrategyTypes(String type)
	{
		ILoadTestManager thisManager = null;
		thisManager = ServerManager.getManager(type);
		if (thisManager != null)
			return thisManager.ReturnStrategyTypes();

		return null;
	}

	public String RestrictStringLength(String MyString, int count, boolean flag)
	{
		if (MyString == null)
			return "";

		if (MyString.length() > count)
		{
			MyString = MyString.substring(0, count);
			if (flag == true)
				MyString = MyString + "...";
		}
		return MyString;
	}

	public String RestrictStringLengthRev(String MyString, int count, boolean flag)
	{
		if (MyString == null)
			return "";

		if (MyString.length() > (count))
		{
			int spacing = MyString.length() - count;
			MyString = MyString.substring(spacing, MyString.length());
			if (flag == true)
				MyString = "..." + MyString;
		}
		return MyString;
	}

	public String TransformVars(String Output, HashMap<String, String> LoseVars, Map<String, List<String>> params, LoadTestLogger Log)
	{
		Date now = new Date();

		Output = Output.replace("LOADTESTVERSION", ServerManager.returnLoadTestVersion());
		Output = Output.replace("WOWZAVERSION", this.server.getVersion());
		Output = Output.replace("DATESTARTED", this.server.getDateStarted().substring(0, this.server.getDateStarted().length() - 5));
		Locale localeObject = new Locale("GB");
		DateFormat dateFormat = new SimpleDateFormat("EEE, MMM d yyyy HH:mm:ss", localeObject);
		Output = Output.replace("DATECURRENT", dateFormat.format(now.getTime()));
		Output = Output.replace("TIMERUNNING", this.server.getTimeRunning());
		Output = Output.replace("THISDATE", now.toString());
		Output = Output.replace("RANDOM", String.valueOf(now.getTime()));
		Output = Output.replace("ARCHTYPE", System.getProperty("sun.arch.data.model"));
		Output = Output.replace("OSTYPE", System.getProperty("os.name"));
		try
		{
			String host = "";
			if (params.get("HOSTNAME").get(0).contains(":"))
			{
				host = params.get("HOSTNAME").get(0).split(":")[0];
				Output = Output.replace("HOSTNAME", host);
			}
			else
			{
				host = params.get("HOSTNAME").get(0);
				Output = Output.replace("HOSTNAME", host);
			}
		}
		catch (Exception failedHost)
		{
			Output = Output.replace("HOSTNAME", "");
		}

		synchronized(LoseVars)
		{
			Set<String> LoseSet = LoseVars.keySet();
			Iterator<String> LoseIter = LoseSet.iterator();
			while (LoseIter.hasNext())
			{
				String Key = LoseIter.next();
				String Value = LoseVars.get(Key);

				if (Key.equalsIgnoreCase("ContentName"))
				{
					try
					{
						Value = URLDecoder.decode(Value, "UTF-8");
					}
					catch (Exception g)
					{
					}
				}

				Output = Output.replace(Key, Value);
			}
		}
		return Output;
	}

	public String ServerTransform(String Output, IVHost ThisVHost, GlobalTester thisTester)
	{
		String AppOutput = "";

		AppOutput += "<div id=\"ListClientsheadcont\">\n";
		AppOutput += "<div id=\"ListClientsheadcol_one\">Protocol</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_two\">Clients</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_three\">Reconnects</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_four\">Bytes In</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_five\">Bytes Out</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_six\">Bytes Lost</div>\n";
		AppOutput += "<br style=\"clear: both;\" />\n";
		AppOutput += "</div>\n";

		long totalConnected = 0;
		long totalReconnected = 0;
		long totalinBytes = 0;
		long totaloutBytes = 0;
		long totallostBytes = 0;

		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();

		Iterator<String> IManagersOptions = Managers.keySet().iterator();
		while (IManagersOptions.hasNext())
		{
			String Manager = IManagersOptions.next();
			ILoadTestManager ThisManager = Managers.get(Manager);

			HashMap<String, String> ClientInfo = ThisManager.returnConnectedClientInformation();
			AppOutput += "<div id=\"ListClientscont\">\n";
			AppOutput += "<div id=\"ListClientscontcol_one\">" + ThisManager.getPublicManagerName() + "</a></div>\n";
			AppOutput += "<div id=\"ListClientscontcol_two\">" + ClientInfo.get("CONNECTED") + "</div>\n";
			AppOutput += "<div id=\"ListClientscontcol_three\">" + ClientInfo.get("RETRIES") + "</div>\n";
			AppOutput += "<div id=\"ListClientscontcol_four\">" + ClientInfo.get("INBYTES") + "</div>\n";
			AppOutput += "<div id=\"ListClientscontcol_five\">" + ClientInfo.get("OUTBYTES") + "</div>\n";
			AppOutput += "<div id=\"ListClientscontcol_six\">" + ClientInfo.get("LOSTBYTES") + "</div>\n";
			AppOutput += "</div>";
			AppOutput += "<br style=\"clear: both;\" />\n";

			totalConnected += Long.valueOf(ClientInfo.get("CONNECTED"));
			totalReconnected += Long.valueOf(ClientInfo.get("RETRIES"));
			totalinBytes += Long.valueOf(ClientInfo.get("INBYTES"));
			totaloutBytes += Long.valueOf(ClientInfo.get("OUTBYTES"));
			totallostBytes += Long.valueOf(ClientInfo.get("LOSTBYTES"));
		}

		AppOutput += "<div id=\"ListClientsheadcont\">\n";
		AppOutput += "<div id=\"ListClientsheadcol_one\">Total</a></div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_two\">" + String.valueOf(totalConnected) + "</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_three\">" + String.valueOf(totalReconnected) + "</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_four\">" + String.valueOf(totalinBytes) + "</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_five\">" + String.valueOf(totaloutBytes) + "</div>\n";
		AppOutput += "<div id=\"ListClientsheadcol_six\">" + String.valueOf(totallostBytes) + "</div>\n";
		AppOutput += "<br style=\"clear: both;\" />\n";
		AppOutput += "</div>";

		Output = Output.replace("ALLCLIENTLIST", AppOutput);

		return Output;
	}

	public String ClientTestDetailTransform(String Output, IVHost vhost, Map<String, List<String>> params, ConfigurationControl configuration, GlobalTester thisTester)
	{
		int clientsFound = 0;

		String MyOutput = "";
		String AppOutput = "";

		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();

		Iterator<String> IManagersOptions = Managers.keySet().iterator();
		while (IManagersOptions.hasNext())
		{
			String Manager = IManagersOptions.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			String privateName = ThisManager.getPrivateManagerName().toUpperCase();
			ClientTestConfiguration clientProtocol = null;

			try
			{
				clientProtocol = ServerManager.returnConfigurationControl().returnClientInformation(privateName);
			}
			catch (Exception RTSPE)
			{
				clientProtocol = null;
			}

			if (clientProtocol != null)
			{
				if (Integer.valueOf(clientProtocol.getClientNumber()) > 0)
				{
					clientsFound++;

					AppOutput += "<div id=\"ListTestClientcont\">\n";
					AppOutput += "<div id=\"ListTestClientcontcol_one\">" + privateName.toLowerCase() + "</div>\n";
					AppOutput += "<div id=\"ListTestClientcontcol_two\">" + clientProtocol.getClientNumber() + "</div>\n";

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-connecthold"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Connect/Hold</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">N/A</div>\n";
					}

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-connectdisconnect"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Connect/Disconnect</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">" + clientProtocol.getStrategyConnectHoldTime() + "/" + clientProtocol.getStrategyConnectRandomTime() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">" + clientProtocol.getStrategyConnectWaitTime() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">N/A</div>\n";
					}

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-connectholdbitrateswitch"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Connect/Hold/Switch</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">" + clientProtocol.getStrategySwitchDelay() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">" + clientProtocol.getStrategySwitchCycle() + "</div>\n";
					}

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-connectdisconnectbitrateswitch"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Connect/Disconnect/Switch</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">" + clientProtocol.getStrategyConnectHoldTime() + "/" + clientProtocol.getStrategyConnectRandomTime() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">" + clientProtocol.getStrategyConnectWaitTime() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">" + clientProtocol.getStrategySwitchDelay() + "</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">" + clientProtocol.getStrategySwitchCycle() + "</div>\n";
					}

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-continuousrandomseek"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Random Seek</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">N/A</div>\n";
					}

					if (clientProtocol.getStrategyType().equalsIgnoreCase("strategy-mode-continuousfastrandomseek"))
					{
						AppOutput += "<div id=\"ListTestClientcontcol_three\">Fast Random Seek</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_four\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_five\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_six\">N/A</div>\n";
						AppOutput += "<div id=\"ListTestClientcontcol_seven\">N/A</div>\n";
					}

					AppOutput += "</div>";
					AppOutput += "<br style=\"clear: both;\" />\n";
				}
			}
		}

		if (clientsFound == 0)
		{
			MyOutput += "<div id=\"ListTestClientcont\">\n";
			MyOutput += "<div id=\"ListTestClientcolNone\">No Clients Ready</div>\n";
			MyOutput += "</div>\n";
			MyOutput += "<br style=\"clear: both;\" />\n";
		}
		else
		{
			MyOutput += "<div id=\"ListTestClientheadcont\">\n";
			MyOutput += "<div id=\"ListTestClientheadcol_one\">Protocol</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_two\">Number</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_three\">Strategy</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_four\">HoldTime</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_five\">WaitTime</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_six\">SwitchTime</div>\n";
			MyOutput += "<div id=\"ListTestClientheadcol_seven\">SwitchType</div>\n";
			MyOutput += "<br style=\"clear: both;\" />\n";
			MyOutput += "</div>\n";
		}

		MyOutput += AppOutput;

		Output = Output.replace("ALLCLIENTLIST", MyOutput);

		return Output;
	}

	public String ClientConfJSTransform(String Output, String vhostName, IVHost vhost)
	{
		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();

		if (Output.contains("CLIENTTYPELIST"))
		{
			String clientList = "";
			Iterator<String> IManagers = Managers.keySet().iterator();
			while (IManagers.hasNext())
			{
				String Manager = IManagers.next();
				ILoadTestManager ThisManager = Managers.get(Manager);
				clientList += "\t\t\"" + ThisManager.getPrivateManagerName() + "\",\n";
			}

			if (clientList.length() > 1)
				clientList = clientList.substring(0, clientList.length() - 2);

			Output = Output.replace("CLIENTTYPELIST", clientList);
		}

		if (Output.contains("CLIENTTYPEPARAMETERLIST"))
		{
			String clientList = "";
			Iterator<String> IManagers = Managers.keySet().iterator();
			while (IManagers.hasNext())
			{
				String Manager = IManagers.next();
				ILoadTestManager ThisManager = Managers.get(Manager);
				clientList += ThisManager.ReturnFormAttributes();
			}
			Output = Output.replace("CLIENTTYPEPARAMETERLIST", clientList);
		}

		return Output;
	}

	public String ClientConfDetailTransform(String Output, IVHost vhost, Map<String, List<String>> params, GlobalTester thisTester, boolean updated)
	{
		String ClientType = "";
		if (params.containsKey("ClientType"))
			ClientType = checkString(params, "ClientType");

		Output = Output.replace("CLIENTTYPEOPTIONS", BuildClientType(ClientType));

		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();
		String ClientForm = "";

		Iterator<String> IManagersConfContent = Managers.keySet().iterator();
		while (IManagersConfContent.hasNext())
		{
			String Manager = IManagersConfContent.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			if (updated == false)
				ClientForm += ThisManager.getConfContent(this);
			else
				ClientForm += ThisManager.getConfContentUpdated(this);
		}
		Output = Output.replace("CLIENTTYPEINPUTFORM", ClientForm);

		Iterator<String> IManagersOptions = Managers.keySet().iterator();
		while (IManagersOptions.hasNext())
		{
			String Manager = IManagersOptions.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			String privateName = ThisManager.getPrivateManagerName();

			String StrategyType = privateName + "-strategy-mode";
			String BitrateType = privateName + "-bitrate-mode";
			String SwithingCStrategyType = privateName + "-strategy-cswitch-strategy";
			String SwithingCDStrategyType = privateName + "-strategy-cdswitch-strategy";

			if (params.containsKey(BitrateType))
				BitrateType = checkString(params, BitrateType);

			StrategyType = checkString(params, StrategyType);
			SwithingCStrategyType = checkString(params, SwithingCStrategyType);
			SwithingCDStrategyType = checkString(params, SwithingCDStrategyType);
			Output = Output.replace(privateName + "STRATEGYOPTIONMODE", StrategyType);

			Output = Output.replace(privateName.toUpperCase() + "STRATEGYMODE", BuildStrategyType(StrategyType, privateName));

			Output = Output.replace(privateName.toUpperCase() + "SWITCHCSTRATEGYMODE", BuildSwitchStrategyType(SwithingCStrategyType, ThisManager.ReturnSwitchStrategyTypes()));

			Output = Output.replace(privateName.toUpperCase() + "SWITCHCDSTRATEGYMODE", BuildSwitchStrategyType(SwithingCDStrategyType, ThisManager.ReturnSwitchStrategyTypes()));
		}

		Iterator<String> IManagers = Managers.keySet().iterator();
		while (IManagers.hasNext())
		{
			String Manager = IManagers.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			String[][] paramsList = ThisManager.ReturnDefaultValues();
			try
			{
				for (int paramCount = 0; paramCount < paramsList.length; paramCount++)
				{
					String HTMLKey = paramsList[paramCount][0];
					String ParamKey = paramsList[paramCount][1];
					String DefaultVal = paramsList[paramCount][2];

					if (Output.contains(HTMLKey))
					{
						String ThisOption = DefaultVal;
						if (params.containsKey(ParamKey))
							ThisOption = checkString(params, ParamKey);

						if (updated == false)
							Output = Output.replace(HTMLKey, ThisOption);
						else
							Output = Output.replace(HTMLKey, RestrictStringLength(ThisOption, 30, true));
					}
				}
			}
			catch (Exception invalidOption)
			{
				if (this.debug == true)
					this.log.LogMessage("Invalid ReturnDefaultValues from " + ThisManager.getPublicManagerName());
			}
		}

		if (Output.contains("CLIENTCTYPEOPTION"))
		{
			Output = Output.replace("CLIENTCTYPEOPTION", checkString(params, "ClientType"));
			Output = Output.replace("CLIENTLTYPEOPTION", FindOptionHashMap(ReturnClientTypes(), checkString(params, "ClientType")));
		}

		Iterator<String> IManagersHTML = Managers.keySet().iterator();
		while (IManagersHTML.hasNext())
		{
			String Manager = IManagersHTML.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			Output = ThisManager.MapCustomHTMLParameters(Output, params, this);
		}

		return Output;
	}

	public String BuildIndexConfiguration()
	{
		String General = "<li>\n";
		General = General + "\t\t\t<a href=\"javascript:void(0)\" class=\"navhead\" id=\"itemtwo\">Setup</a>\n";
		General = General + "\t\t\t<ul class=\"itemtwo subnav\" style=\"display:none;\">\n";
		General = General + "\t\t\t<li><a href=\"PAGESPATH/client_conf.html\" class=\"inpage\">Configure Test</a></li>\n";
		General = General + "\t\t\t<li><a href=\"PAGESPATH/starttest.html\" class=\"inpage\">Start Test</a></li>\n";
		General = General + "\t\t\t<li><a href=\"PAGESPATH/stoptest.html\" class=\"inpage\">Stop Test</a></li>\n";
		General = General + "\t\t\t</ul>\n";
		General = General + "\t\t\t</li>\n";
		return General;
	}

	public String BuildIndexClient()
	{
		String General = "<li>\n";
		General = General + "\t\t\t<a href=\"javascript:void(0)\" class=\"navhead\" id=\"itemthree\">Test Information</a>\n";
		General = General + "\t\t\t<ul class=\"itemthree subnav\" style=\"display:none;\">\n";
		General = General + "\t\t\t<li><a href=\"PAGESPATH/server.html\" class=\"inpage\">Summary</a></li>\n";
		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();
		Iterator<String> IManagers = Managers.keySet().iterator();
		while (IManagers.hasNext())
		{
			String Manager = IManagers.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			if (ThisManager.getDetailEnabled() == true)
				General = General + "\t\t\t<li><a href=\"PAGESPATH/" + ThisManager.getDetailName() + "\" class=\"inpage\">RTMP</a></li>\n";
		}
		General = General + "\t\t\t</ul>\n";
		General = General + "\t\t\t</li>\n";
		return General;
	}

	public String BuildIndexCSS()
	{
		String CSS = "\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/reset.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/welcome.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/index.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/general_all.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/all_client_list.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/client_conf.css\" type=\"text/css\" media=\"all\"/>\n";
		CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/test_conf.css\" type=\"text/css\" media=\"all\"/>\n";

		HashMap<String, ILoadTestManager> Managers = ServerManager.getManagerMap();
		Iterator<String> IManagers = Managers.keySet().iterator();
		while (IManagers.hasNext())
		{
			String Manager = IManagers.next();
			ILoadTestManager ThisManager = Managers.get(Manager);
			String Name = ThisManager.getCSSName();
			CSS += "\t<link rel=\"stylesheet\" href=\"CSSPATH/" + Name + "\" type=\"text/css\" media=\"all\"/>\n";
		}
		return CSS;
	}

	public String BuildStrategyType(String choice, String prefix)
	{
		String Output = "";
		String[][] AppTypes = ReturnStrategyTypes(prefix);
		for (int a = 0; a < AppTypes.length; a++)
		{
			Output += "<option value=\"" + AppTypes[a][0] + "\" ";
			if (choice.equals(AppTypes[a][0]))
			{
				Output += "selected ";
			}
			Output += ">" + AppTypes[a][1] + "</option>\n";
		}
		return Output;
	}

	public String BuildSwitchStrategyType(String choice, String[][] AppTypes)
	{
		String Output = "";
		for (int a = 0; a < AppTypes.length; a++)
		{
			Output += "<option value=\"" + AppTypes[a][0] + "\" ";
			if (choice.equals(AppTypes[a][0]))
				Output += "selected ";

			Output += ">" + AppTypes[a][1] + "</option>\n";
		}
		return Output;
	}

	public String BuildClientType(String choice)
	{
		String Output = "";
		HashMap<String, String> AppTypes = ReturnClientTypes();
		Iterator<String> IAppTypes = AppTypes.keySet().iterator();
		while (IAppTypes.hasNext())
		{
			String privateName = IAppTypes.next();
			String publicName = AppTypes.get(privateName);

			Output += "<option value=\"" + privateName + "\" ";
			if (choice.equals(privateName))
				Output += "selected ";

			Output += ">" + publicName + "</option>\n";
		}
		return Output;
	}
}
