/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.security;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.IModuleOnConnect;
import com.wowza.wms.module.IModuleOnStream;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.security.SecureTokenManager;
import com.wowza.wms.plugin.security.encryption.TEA;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;

public class ModuleSecureToken
extends ModuleBase
implements IModuleOnConnect,
IModuleOnStream {
    private boolean doPlay = false;
    private boolean doPublish = false;
    private boolean doCreate = true;
    private StreamActions streamActions = new StreamActions();

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string;
        SecureTokenManager secureTokenManager = SecureTokenManager.getInstance(iClient.getVHost());
        String string2 = secureTokenManager.newGUID();
        iClient.getProperties().put((Object)"secureToken", (Object)string2);
        iClient.getProperties().put((Object)"secureTokenOK", (Object)new Boolean(false));
        String string3 = (String)iClient.getAppInstance().getProperties().get((Object)"secureTokenSharedSecret");
        if (string3 != null) {
            iClient.addAcceptConnectionAttribute("secureToken", TEA.encrypt(string2, string3));
        } else {
            string = "Error: SecureToken: secureTokenSharedSecret property not defined in: " + iClient.getApplication().getConfigPath();
            iClient.addAcceptConnectionAttribute("secureTokenError", string);
            ModuleSecureToken.getLogger().error(string);
        }
        string = (String)iClient.getAppInstance().getProperties().get((Object)"secureTokenTarget");
        if (string != null) {
            this.doPlay = false;
            this.doPublish = false;
            this.doCreate = false;
            String[] stringArray = string.split("[,]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].trim().toLowerCase();
                if (string4.equals("create")) {
                    this.doCreate = true;
                    continue;
                }
                if (string4.equals("publish")) {
                    this.doPublish = true;
                    continue;
                }
                if (!string4.equals("play")) continue;
                this.doPlay = true;
            }
        }
        ModuleSecureToken.getLogger().info("SecureTokenTarget: create:" + this.doCreate + " play:" + this.doPlay + " publish:" + this.doPublish);
    }

    private void killClient(IClient iClient) {
        ((Client)iClient).setShutdownClient(true);
        ((Client)iClient).doIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureTokenResponse(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSProperties wMSProperties = iClient.getProperties();
        String string2 = null;
        WMSProperties wMSProperties2 = wMSProperties;
        synchronized (wMSProperties2) {
            string2 = (String)wMSProperties.get((Object)"secureToken");
        }
        boolean bl = false;
        if (string2 == null) {
            ModuleSecureToken.getLogger().error("Error: SecureToken: Challenge not found: kill connection");
            this.killClient(iClient);
        } else if (string == null) {
            ModuleSecureToken.getLogger().error("Error: SecureToken: Response not found: kill connection");
            this.killClient(iClient);
        } else if (!string.equals(string2)) {
            ModuleSecureToken.getLogger().error("Error: SecureToken: Challenge does not equal response: kill connection");
            this.killClient(iClient);
        } else {
            ModuleSecureToken.getLogger().debug("SecureToken: Challenge matches response.");
            WMSProperties wMSProperties3 = wMSProperties;
            synchronized (wMSProperties3) {
                wMSProperties.put((Object)"secureTokenOK", (Object)new Boolean(true));
            }
            bl = true;
        }
        ModuleSecureToken.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (AMFData)new AMFDataItem(bl));
    }

    public void onConnectAccept(IClient iClient) {
    }

    public void onConnectReject(IClient iClient) {
    }

    public void onDisconnect(IClient iClient) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSecureToken(IClient iClient) {
        boolean bl = true;
        if (iClient != null) {
            WMSProperties wMSProperties;
            WMSProperties wMSProperties2 = wMSProperties = iClient.getProperties();
            synchronized (wMSProperties2) {
                Boolean bl2 = (Boolean)wMSProperties.get((Object)"secureTokenOK");
                if (!bl2.booleanValue()) {
                    ModuleSecureToken.getLogger().error("Error: SecureToken: Action before response received: kill connection");
                    this.killClient(iClient);
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        boolean bl = true;
        if (this.doCreate) {
            bl = this.checkSecureToken(iMediaStream.getClient());
        }
        if (bl && (this.doPlay || this.doPublish)) {
            iMediaStream.addClientListener((IMediaStreamActionNotify)this.streamActions);
        }
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
    }

    class StreamActions
    implements IMediaStreamActionNotify {
        StreamActions() {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
            if (ModuleSecureToken.this.doPlay) {
                ModuleSecureToken.this.checkSecureToken(iMediaStream.getClient());
            }
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            if (ModuleSecureToken.this.doPublish) {
                ModuleSecureToken.this.checkSecureToken(iMediaStream.getClient());
            }
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        }
    }
}

