/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.security;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.security.SecureTokenManager;
import com.wowza.wms.plugin.security.encryption.TEA;
import com.wowza.wms.request.RequestFunction;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureURLParams
extends ModuleBase {
    private boolean denyallConnections = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        IApplication iApplication = iApplicationInstance.getApplication();
        String string = iApplication.getApplicationPath() + File.separatorChar + "secureurlparams" + File.separatorChar + iApplicationInstance.getName();
        File file = new File(string);
        if (!file.exists()) {
            boolean bl = false;
            String[] stringArray = new String[]{"connect", "play", "publish"};
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = iApplicationInstance.getProperties().getPropertyStr("secureurlparams." + stringArray[i]);
                if (string2 == null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.denyallConnections = true;
            }
        }
        SecureURLParams.getLogger().info("SecureURLParams.onAppStart: " + iApplication.getName() + "/" + iApplicationInstance.getName());
        if (this.denyallConnections) {
            SecureURLParams.getLogger().info("SecureURLParams.onAppStart: All connections to this application instance will be denied. The \"secureurlparams\" folder for this application instance is missing and there are no \"secureurlparams\" properties defined in [install-dir]/conf/" + iApplication.getName() + "/Application.xml.");
        }
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        IApplication iApplication = iApplicationInstance.getApplication();
        SecureURLParams.getLogger().info("SecureURLParams.onAppStop: " + iApplication.getName() + "/" + iApplicationInstance.getName());
    }

    String doURLDecodeStr(String string) {
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            SecureURLParams.getLogger().error("URLDecoder: " + exception.toString());
        }
        return string2;
    }

    boolean checkFolder(String string, IClient iClient) {
        IApplicationInstance iApplicationInstance = SecureURLParams.getAppInstance((IClient)iClient);
        IApplication iApplication = SecureURLParams.getApplication((IClient)iClient);
        boolean bl = false;
        if (!bl) {
            String string2 = iApplication.getApplicationPath();
            string2 = string2 + File.separatorChar + "secureurlparams" + File.separatorChar + iApplicationInstance.getName();
            File file = new File(string2 + File.separatorChar + string);
            bl = file.exists();
        }
        if (!bl) {
            bl = iApplicationInstance.getProperties().getPropertyStr("secureurlparams." + string) != null;
        }
        return bl;
    }

    List<String[]> parseQueryStr(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("[&]");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("[=]");
                if (stringArray2.length != 2) continue;
                arrayList.add(stringArray2);
            }
        }
        return arrayList;
    }

    boolean checkParams(String string, IClient iClient) {
        File file;
        Boolean bl = false;
        IApplicationInstance iApplicationInstance = SecureURLParams.getAppInstance((IClient)iClient);
        IApplication iApplication = SecureURLParams.getApplication((IClient)iClient);
        String string2 = iApplication.getApplicationPath();
        string2 = string2 + File.separatorChar + "secureurlparams" + File.separatorChar + iApplicationInstance.getName();
        WMSLogger wMSLogger = null;
        if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
            wMSLogger = WMSLoggerFactory.getLogger(null);
        }
        if ((file = new File(string2 + File.separatorChar + string)).exists()) {
            String string3 = iClient.getQueryStr();
            List<String[]> list = this.parseQueryStr(string3);
            if (list.size() > 0) {
                for (String[] stringArray : list) {
                    File file2 = new File(string2 + File.separatorChar + string + File.separatorChar + this.doURLDecodeStr(stringArray[1]) + "." + this.doURLDecodeStr(stringArray[0]));
                    boolean bl2 = file2.exists();
                    if (wMSLogger != null) {
                        wMSLogger.debug("SecureURLParams: " + string + ": " + (bl2 ? "SUCCEED" : "FAIL") + " (file: " + file2.getPath() + ")");
                    }
                    if (!bl2) continue;
                    bl = true;
                    break;
                }
            } else if (wMSLogger != null) {
                wMSLogger.debug("SecureURLParams: " + string + ": FAIL (no query parameters)");
            }
        } else {
            String string4 = iApplicationInstance.getProperties().getPropertyStr("secureurlparams." + string);
            if (string4 == null) {
                bl = true;
                if (wMSLogger != null) {
                    wMSLogger.debug("SecureURLParams: " + string + ": SUCCEED (no folder found [" + string2 + "], no property found [" + "secureurlparams." + string + "])");
                }
            } else if ((string4 = string4.trim()).length() == 0) {
                bl = false;
                if (wMSLogger != null) {
                    wMSLogger.debug("SecureURLParams: " + string + ": FAIL (property is empty  [" + "secureurlparams." + string + "])");
                }
            } else {
                List<String[]> list;
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = string4.split("[,]");
                for (int i = 0; i < stringArray.length; ++i) {
                    list = stringArray[i].trim();
                    arrayList.add((String)((Object)list));
                }
                String string5 = iClient.getQueryStr();
                list = this.parseQueryStr(string5);
                if (list.size() > 0) {
                    for (String[] stringArray2 : list) {
                        String string6 = this.doURLDecodeStr(stringArray2[1]) + "." + this.doURLDecodeStr(stringArray2[0]);
                        boolean bl3 = arrayList.contains(string6);
                        if (wMSLogger != null) {
                            wMSLogger.debug("SecureURLParams: " + string + ": " + (bl3 ? "SUCCEED" : "FAIL") + " (property: " + string6 + ")");
                        }
                        if (!bl3) continue;
                        bl = true;
                        break;
                    }
                } else if (wMSLogger != null) {
                    wMSLogger.debug("SecureURLParams: " + string + ": FAIL (no query parameters)");
                }
            }
        }
        return bl;
    }

    private void killClient(IClient iClient) {
        ((Client)iClient).setShutdownClient(true);
        ((Client)iClient).doIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureTokenResponse(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSProperties wMSProperties = iClient.getProperties();
        String string2 = null;
        WMSProperties wMSProperties2 = wMSProperties;
        synchronized (wMSProperties2) {
            string2 = (String)wMSProperties.get((Object)"secureToken");
        }
        boolean bl = false;
        if (string2 == null) {
            SecureURLParams.getLogger().error("Error: SecureToken: Challenge not found: kill connection");
            this.killClient(iClient);
        } else if (string == null) {
            SecureURLParams.getLogger().error("Error: SecureToken: Response not found: kill connection");
            this.killClient(iClient);
        } else if (!string.equals(string2)) {
            SecureURLParams.getLogger().error("Error: SecureToken: Challenge does not equal response: kill connection");
            this.killClient(iClient);
        } else {
            SecureURLParams.getLogger().debug("SecureToken: Challenge matches response.");
            WMSProperties wMSProperties3 = wMSProperties;
            synchronized (wMSProperties3) {
                wMSProperties.put((Object)"secureTokenOK", (Object)new Boolean(true));
            }
            bl = true;
        }
        SecureURLParams.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (AMFData)new AMFDataItem(bl));
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.denyallConnections || !this.checkParams("connect", iClient)) {
            SecureURLParams.getLogger().info("SecureURLParams: onConnect: rejected");
            iClient.rejectConnection("SecureURLParams: reject connection");
        } else {
            String string = (String)iClient.getAppInstance().getProperties().get((Object)"secureTokenSharedSecret");
            if (string != null) {
                SecureTokenManager secureTokenManager = SecureTokenManager.getInstance(iClient.getVHost());
                String string2 = secureTokenManager.newGUID();
                iClient.getProperties().put((Object)"secureToken", (Object)string2);
                iClient.getProperties().put((Object)"secureTokenOK", (Object)new Boolean(false));
                iClient.addAcceptConnectionAttribute("secureToken", TEA.encrypt(string2, string));
                SecureURLParams.getLogger().debug("SecureURLParams: generate SecureToken GUID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSecureToken(IClient iClient) {
        boolean bl = true;
        if (iClient != null) {
            WMSProperties wMSProperties;
            WMSProperties wMSProperties2 = wMSProperties = iClient.getProperties();
            synchronized (wMSProperties2) {
                Boolean bl2 = (Boolean)wMSProperties.get((Object)"secureTokenOK");
                SecureURLParams.getLogger().debug("SecureURLParams: Check SecureToken: " + bl2);
                if (!bl2.booleanValue()) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void releaseStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = true;
        if (this.checkFolder("publish", iClient)) {
            bl = this.checkParams("publish", iClient);
        } else if (iClient.getProperties().get((Object)"secureTokenOK") != null) {
            bl = this.checkSecureToken(iClient);
        }
        if (bl) {
            SecureURLParams.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            SecureURLParams.getLogger().info("SecureURLParams: releaseStream: rejected");
            this.killClient(iClient);
        }
    }

    public void publish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = true;
        if (this.checkFolder("publish", iClient)) {
            bl = this.checkParams("publish", iClient);
        } else if (iClient.getProperties().get((Object)"secureTokenOK") != null) {
            bl = this.checkSecureToken(iClient);
        }
        if (bl) {
            SecureURLParams.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            SecureURLParams.getLogger().info("SecureURLParams: publish: rejected");
            this.killClient(iClient);
        }
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = true;
        if (this.checkFolder("play", iClient)) {
            bl = this.checkParams("play", iClient);
        } else if (iClient.getProperties().get((Object)"secureTokenOK") != null) {
            bl = this.checkSecureToken(iClient);
        }
        if (bl) {
            SecureURLParams.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            SecureURLParams.getLogger().info("SecureURLParams: play: rejected");
            this.killClient(iClient);
        }
    }
}

