/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.security;

import com.wowza.util.Base64;
import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.security.SecureTokenManager;
import com.wowza.wms.plugin.security.encryption.TEA;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRTMPAuthenticate
extends ModuleBase {
    public static final String AUTHMODE = "adobe";
    public static final String AUTHFLASHVERSIONS = "Wirecast/|FME/|FMLE/";
    public static final String AUTHPASSWORDFILEPATH = "${com.wowza.wms.context.VHostConfigHome}/conf/publish.password";
    private Random rnd = null;
    private Map<String, PendingAuth> pendingAuths = new HashMap<String, PendingAuth>();
    private MessageDigest md5Digest = null;
    private File passwordFile = null;
    private String rtmpEncoderAuthenticationFlashVersions = "Wirecast/|FME/|FMLE/";
    private String[] flashVersions = new String[0];
    private List<Integer> publishers = new ArrayList<Integer>();
    private String sharedSecret = null;
    private boolean requireSecureConnection = false;
    private String usernamePasswordProviderClass = null;

    public ModuleRTMPAuthenticate() {
        this.rnd = new Random(System.currentTimeMillis());
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleRTMPAuthenticate.class).warn("ModuleRTMPEncoderAuthenticate.ModuleRTMPEncoderAuthenticate: " + exception.toString());
        }
    }

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        String string;
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.rtmpEncoderAuthenticationFlashVersions = iApplicationInstance.getProperties().getPropertyStr("rtmpEncoderAuthenticationFlashVersions", this.rtmpEncoderAuthenticationFlashVersions);
        this.sharedSecret = wMSProperties.getPropertyStr("secureTokenSharedSecret");
        this.requireSecureConnection = iApplicationInstance.getProperties().getPropertyBoolean("requireSecureConnection", this.requireSecureConnection);
        this.usernamePasswordProviderClass = iApplicationInstance.getProperties().getPropertyStr("usernamePasswordProviderClass", this.usernamePasswordProviderClass);
        if (this.rtmpEncoderAuthenticationFlashVersions != null && this.rtmpEncoderAuthenticationFlashVersions.trim().length() > 0) {
            this.flashVersions = this.rtmpEncoderAuthenticationFlashVersions.split("[|]");
            for (int i = 0; i < this.flashVersions.length; ++i) {
                this.flashVersions[i] = this.flashVersions[i].trim();
            }
        }
        if ((string = iApplicationInstance.getProperties().getPropertyStr("rtmpEncoderAuthenticateFile", AUTHPASSWORDFILEPATH)) != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables((String)string, hashMap);
            this.passwordFile = new File(string);
        }
        ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.onAppStart: SecureToken is " + (this.sharedSecret == null ? "off" : "on"));
        if (this.passwordFile != null) {
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.onAppStart: Authorization password file: " + this.passwordFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateHashBytes(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = this.md5Digest;
            synchronized (messageDigest) {
                byArray2 = this.md5Digest.digest(byArray);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleRTMPAuthenticate.class).warn("ModuleRTMPEncoderAuthenticate.generateHashBytes: " + exception.toString());
        }
        return byArray2;
    }

    private Map<String, String> splitQueryStr(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("[&]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf("=");
                if (n >= 0) {
                    String string3 = string2.substring(n + 1);
                    hashMap.put(string2.substring(0, n), string3);
                    continue;
                }
                hashMap.put(string2, null);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect(IClient iClient) {
        List<Integer> list = this.publishers;
        synchronized (list) {
            this.publishers.remove(new Integer(iClient.getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPublisher(IClient iClient) {
        boolean bl = false;
        List<Integer> list = this.publishers;
        synchronized (list) {
            bl = this.publishers.contains(new Integer(iClient.getClientId()));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRTMPAuthenticateOnConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl;
        String string = iClient.getQueryStr();
        Map<String, String> map = this.splitQueryStr(string);
        String string2 = map.get("authmod");
        String string3 = map.get("response");
        String string4 = map.get("opaque");
        String string5 = map.get("challenge");
        String string6 = map.get("user");
        boolean bl2 = string2 == null ? false : string6 != null && string2.equals(AUTHMODE);
        boolean bl3 = bl = string3 != null && string4 != null && string5 != null;
        if (bl2 && bl) {
            PendingAuth pendingAuth = null;
            Map<String, PendingAuth> map2 = this.pendingAuths;
            synchronized (map2) {
                pendingAuth = this.pendingAuths.remove(string4);
            }
            boolean bl4 = true;
            String string7 = "[ AccessManager.Reject ] : [ authmod=adobe ] : ?reason=authfailed";
            if (pendingAuth != null) {
                string7 = "[ AccessManager.Reject ] : [ authmod=adobe ] : ?reason=authfailed&opaque=" + pendingAuth.challenge;
                IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
                if (this.usernamePasswordProviderClass != null) {
                    iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider((String)this.usernamePasswordProviderClass);
                } else if (this.passwordFile != null) {
                    iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
                }
                if (iAuthenticateUsernamePasswordProvider != null) {
                    iAuthenticateUsernamePasswordProvider.setClient(iClient);
                    String string8 = iAuthenticateUsernamePasswordProvider.getPassword(pendingAuth.username);
                    if (string8 != null) {
                        byte[] byArray = pendingAuth.username.getBytes();
                        byte[] byArray2 = string8.getBytes();
                        byte[] byArray3 = pendingAuth.salt.getBytes();
                        byte[] byArray4 = pendingAuth.challenge.getBytes();
                        byte[] byArray5 = string5.getBytes();
                        byte[] byArray6 = new byte[byArray.length + byArray3.length + byArray2.length];
                        int n = 0;
                        System.arraycopy(byArray, 0, byArray6, n, byArray.length);
                        System.arraycopy(byArray3, 0, byArray6, n += byArray.length, byArray3.length);
                        System.arraycopy(byArray2, 0, byArray6, n += byArray3.length, byArray2.length);
                        byte[] byArray7 = this.generateHashBytes(byArray6);
                        byte[] byArray8 = Base64.encodeBytes((byte[])byArray7).getBytes();
                        byte[] byArray9 = new byte[byArray8.length + byArray4.length + byArray5.length];
                        n = 0;
                        System.arraycopy(byArray8, 0, byArray9, n, byArray8.length);
                        System.arraycopy(byArray4, 0, byArray9, n += byArray8.length, byArray4.length);
                        System.arraycopy(byArray5, 0, byArray9, n += byArray4.length, byArray5.length);
                        byte[] byArray10 = this.generateHashBytes(byArray9);
                        if (string3.equals(Base64.encodeBytes((byte[])byArray10))) {
                            List<Integer> list = this.publishers;
                            synchronized (list) {
                                this.publishers.add(new Integer(iClient.getClientId()));
                            }
                            bl4 = false;
                        }
                    }
                }
            }
            if (bl4) {
                iClient.rejectConnection();
                iClient.setAcceptConnectionDescription(string7);
            }
        } else if (bl2) {
            String string9 = "[ AccessManager.Reject ] : [ authmod=adobe ] : ?reason=authfailed";
            byte[] byArray = new byte[4];
            byte[] byArray11 = new byte[4];
            this.rnd.nextBytes(byArray);
            String string10 = Base64.encodeBytes((byte[])byArray);
            String string11 = null;
            while (true) {
                this.rnd.nextBytes(byArray11);
                string11 = Base64.encodeBytes((byte[])byArray11);
                Map<String, PendingAuth> map3 = this.pendingAuths;
                synchronized (map3) {
                    if (!this.pendingAuths.containsKey(string11)) {
                        PendingAuth pendingAuth = new PendingAuth(string6, string11, string10);
                        this.pendingAuths.put(string11, pendingAuth);
                        break;
                    }
                }
            }
            string9 = "[ AccessManager.Reject ] : [ authmod=adobe ] : ?reason=needauth&user=" + string6 + "&salt=" + string10 + "&challenge=" + string11 + "&opaque=" + string11;
            iClient.rejectConnection();
            iClient.setAcceptConnectionDescription(string9);
        } else {
            String string12 = "[ AccessManager.Reject ] : [ code=403 need auth; authmod=adobe ] : ";
            iClient.rejectConnection();
            iClient.setAcceptConnectionDescription(string12);
        }
    }

    private void doSecureTokenAuthenticateOnConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.requireSecureConnection && !iClient.isSecure()) {
            iClient.rejectConnection("Secure connection required.");
            this.killClient(iClient);
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.onConnect: rejectConnection: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            return;
        }
        if (this.sharedSecret != null) {
            SecureTokenManager secureTokenManager = SecureTokenManager.getInstance(iClient.getVHost());
            String string = secureTokenManager.newGUID();
            iClient.getProperties().put((Object)"secureToken", (Object)string);
            iClient.getProperties().put((Object)"secureTokenOK", (Object)new Boolean(false));
            iClient.addAcceptConnectionAttribute("secureToken", TEA.encrypt((String)string, (String)this.sharedSecret));
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = false;
        String string = iClient.getFlashVer();
        if (string != null) {
            for (int i = 0; i < this.flashVersions.length; ++i) {
                if (this.flashVersions[i].length() <= 0 || !string.startsWith(this.flashVersions[i])) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.doRTMPAuthenticateOnConnect(iClient, requestFunction, aMFDataList);
        } else {
            this.doSecureTokenAuthenticateOnConnect(iClient, requestFunction, aMFDataList);
        }
    }

    private void killClient(IClient iClient) {
        ((Client)iClient).setShutdownClient(true);
        ((Client)iClient).doIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSecureToken(IClient iClient) {
        boolean bl = true;
        if (this.sharedSecret != null && iClient != null) {
            WMSProperties wMSProperties;
            WMSProperties wMSProperties2 = wMSProperties = iClient.getProperties();
            synchronized (wMSProperties2) {
                Boolean bl2 = (Boolean)wMSProperties.get((Object)"secureTokenOK");
                if (!bl2.booleanValue()) {
                    ModuleRTMPAuthenticate.getLogger().error("ModuleRTMPAuthenticate.checkSecureToken: Action before response received: kill connection: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
                    this.killClient(iClient);
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secureTokenResponse(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSProperties wMSProperties = iClient.getProperties();
        String string2 = null;
        WMSProperties wMSProperties2 = wMSProperties;
        synchronized (wMSProperties2) {
            string2 = (String)wMSProperties.get((Object)"secureToken");
        }
        boolean bl = false;
        if (string2 == null) {
            ModuleRTMPAuthenticate.getLogger().error("ModuleRTMPAuthenticate.checkSecureToken: Challenge not found: kill connection: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        } else if (string == null) {
            ModuleRTMPAuthenticate.getLogger().error("ModuleRTMPAuthenticate.checkSecureToken: Response not found: kill connection: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        } else if (!string.equals(string2)) {
            ModuleRTMPAuthenticate.getLogger().error("ModuleRTMPAuthenticate.checkSecureToken: Challenge does not equal response: kill connection: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        } else {
            ModuleRTMPAuthenticate.getLogger().debug("ModuleRTMPAuthenticate.secureTokenResponse: Challenge matches response.");
            WMSProperties wMSProperties3 = wMSProperties;
            synchronized (wMSProperties3) {
                wMSProperties.put((Object)"secureTokenOK", (Object)new Boolean(true));
            }
            bl = true;
        }
        ModuleRTMPAuthenticate.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (AMFData)new AMFDataItem(bl));
    }

    public void publish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.isPublisher(iClient)) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        } else {
            IMediaStream iMediaStream = ModuleRTMPAuthenticate.getStream((IClient)iClient, (RequestFunction)requestFunction);
            if (iMediaStream != null) {
                ModuleRTMPAuthenticate.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)"NetStream.Publish.Failed", (String)"Not authorized to publish");
            }
        }
    }

    public void releaseStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        if (this.isPublisher(iClient)) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        }
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = this.checkSecureToken(iClient);
        if (bl) {
            ModuleRTMPAuthenticate.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.play: Rejected: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        }
    }

    public void play2(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = this.checkSecureToken(iClient);
        if (bl) {
            ModuleRTMPAuthenticate.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.play2: Rejected: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        }
    }

    public void FCSubscribe(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = this.checkSecureToken(iClient);
        if (bl) {
            ModuleRTMPAuthenticate.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.FCSubscribe: Rejected: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        }
    }

    public void FCUnSubscribe(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = this.checkSecureToken(iClient);
        if (bl) {
            ModuleRTMPAuthenticate.invokePrevious((Object)((Object)this), (IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        } else {
            ModuleRTMPAuthenticate.getLogger().info("ModuleRTMPAuthenticate.FCUnSubscribe: Rejected: clientId:" + iClient.getClientId(), "session", "comment", 403, iClient.getClientId() + "");
            this.killClient(iClient);
        }
    }

    class PendingAuth {
        long time = -1L;
        String username = null;
        String challenge = null;
        String salt = null;

        public PendingAuth(String string, String string2, String string3) {
            this.username = string;
            this.challenge = string2;
            this.salt = string3;
            this.time = System.currentTimeMillis();
        }
    }
}

