/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.publishwithdelay;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.publish.Publisher;
import java.util.ArrayList;
import java.util.List;

public class PublishWithDelayWorker
extends Thread {
    private IApplicationInstance appInstance = null;
    private String srcStreamName = null;
    private String dstStreamName = null;
    private boolean running = true;
    private boolean quit = false;
    private boolean isFirstVideo = true;
    private boolean isFirstAudio = true;
    private int lastSrcStreamId = -1;
    private long lastTC = -1L;
    private long lastSeq = -1L;
    private long timecodeOffset = -1L;
    private boolean foundStartPacket = false;
    private int idleTimeout = 50;
    private int delay = 5000;
    private List<AMFPacket> packetList = new ArrayList<AMFPacket>();

    public PublishWithDelayWorker(IApplicationInstance appInstance, String srcStreamName, String dstStreamName) {
        this.appInstance = appInstance;
        this.srcStreamName = srcStreamName;
        this.dstStreamName = dstStreamName;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void quit() {
        this.quit = true;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        publisher = Publisher.createInstance((IApplicationInstance)this.appInstance);
        publisher.publish(this.dstStreamName);
        streams = this.appInstance.getStreams();
        startTime = -1L;
        block10: while (true) {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    stream = streams.getStream(this.srcStreamName);
                    while (stream == null) {
                    }
                    packets = stream.getPlayPackets();
                    if (packets != null && (size = packets.size()) != 0) {
                        if (stream.getSrc() != this.lastSrcStreamId) {
                            this.lastSrcStreamId = stream.getSrc();
                            this.timecodeOffset = -1L;
                            this.lastSeq = -1L;
                            if (startTime == -1L) {
                                startTime = System.currentTimeMillis();
                            }
                            this.foundStartPacket = false;
                        }
                        packet = null;
                        packet = (AMFPacket)packets.get(0);
                        startSeq = packet.getSeq();
                        v0 = startIdx = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - startSeq + 1L);
                        if (startIdx < 0) {
                            startIdx = 0;
                        }
                        if (startIdx < size) {
                            if (!this.foundStartPacket) {
                                idx = size - 1;
                                while (idx >= 0) {
                                    packet = (AMFPacket)packets.get(idx);
                                    packetType = packet.getType();
                                    if ((packetType == 9 || packetType == 8) && packetType == 9 && FLVUtils.isVideoKeyFrame((AMFPacket)packet)) {
                                        startIdx = idx;
                                        timeoffset = 0L;
                                        if (this.lastTC != -1L) {
                                            timeoffset = System.currentTimeMillis() - startTime;
                                        }
                                        this.timecodeOffset = timeoffset - packet.getAbsTimecode();
                                        this.foundStartPacket = true;
                                        break;
                                    }
                                    --idx;
                                }
                            }
                            if (this.foundStartPacket) {
                                idx = startIdx;
                                while (idx < size) {
                                    packet = (AMFPacket)packets.get(idx);
                                    packetType = packet.getType();
                                    this.lastSeq = packet.getSeq();
                                    this.lastTC = adjTimecode = packet.getAbsTimecode() + this.timecodeOffset;
                                    newPacket = new AMFPacket(packetType, 0, packet.getSize());
                                    newPacket.setAbsTimecode(adjTimecode);
                                    newPacket.addData(packet.getData(), 0, packet.getSize());
                                    this.packetList.add(newPacket);
                                    ++idx;
                                }
                            }
                        }
                    }
                    if (stream != null && this.packetList.size() > 0) {
                        maxTimecode = System.currentTimeMillis() - startTime - (long)this.delay;
                        while (maxTimecode > 0L && (amfPacket = this.packetList.get(0)).getAbsTimecode() <= maxTimecode) {
                            switch (amfPacket.getType()) {
                                case 8: {
                                    if (this.isFirstAudio) {
                                        configPacket = stream.getAudioCodecConfigPacket(amfPacket.getAbsTimecode());
                                        if (configPacket != null) {
                                            publisher.addAudioData(configPacket.getData(), configPacket.getSize(), amfPacket.getAbsTimecode());
                                        }
                                        this.isFirstAudio = false;
                                    }
                                    publisher.addAudioData(amfPacket.getData(), amfPacket.getSize(), amfPacket.getAbsTimecode());
                                    break;
                                }
                                case 9: {
                                    if (this.isFirstVideo) {
                                        configPacket = stream.getVideoCodecConfigPacket(amfPacket.getAbsTimecode());
                                        if (configPacket != null) {
                                            publisher.addVideoData(configPacket.getData(), configPacket.getSize(), amfPacket.getAbsTimecode());
                                        }
                                        this.isFirstVideo = false;
                                    }
                                    publisher.addVideoData(amfPacket.getData(), amfPacket.getSize(), amfPacket.getAbsTimecode());
                                    break;
                                }
                                case 15: 
                                case 18: {
                                    publisher.addDataData(amfPacket.getData(), amfPacket.getSize(), amfPacket.getAbsTimecode());
                                }
                            }
                            this.packetList.remove(0);
                            if (this.packetList.size() != 0) continue;
                        }
                    }
                    PublishWithDelayWorker.sleep(this.idleTimeout);
                    var6_6 = this;
                    synchronized (var6_6) {
                        if (this.quit) {
                            this.running = false;
                            break block10;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                WMSLoggerFactory.getLogger(null).error("PublishWithDelayWorker.run: " + e.toString());
                e.printStackTrace();
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
        publisher.unpublish();
        publisher.close();
    }
}

