package com.wowza.wms.plugin.randomaccessreader.file;

import java.io.*;

import com.wowza.io.*;
import com.wowza.wms.logging.*;
import com.wowza.wms.stream.*;
import com.wowza.wms.application.*;

public class FileRandomAccessReader implements IRandomAccessReader
{
	private String basePath = "";
	private String mediaName = "";
	private String mediaExtension = "";
	private String fullPath = "";
	private File file = null;
	private RandomAccessFile randomFile = null;
	private int direction = IRandomAccessReader.FORWARD;
	private boolean sentSeekError = false;
	
	public FileRandomAccessReader()
	{
		WMSLoggerFactory.getLogger(FileRandomAccessReader.class).info("FileRandomAccessReader.constructor");
	}
	
	public void init(IApplicationInstance appInstance, IMediaStream stream, String basePath, String mediaName, String mediaExtension)
	{
		this.basePath = basePath;
		this.mediaName = mediaName;
		this.mediaExtension = mediaExtension;
		
		WMSLoggerFactory.getLogger(FileRandomAccessReader.class).info("FileRandomAccessReader.init: basePath:"+this.basePath+" mediaName:"+this.mediaName+" extension:"+this.mediaExtension);

		while (true)
		{
			this.fullPath = this.basePath + File.separatorChar + this.mediaName;
			this.file = new File(this.fullPath);
			if (this.file.exists())
				break;

			this.fullPath = this.basePath + File.separatorChar + this.mediaName + "." + this.mediaExtension;
			this.file = new File(this.fullPath);
			if (this.file.exists())
				break;
			
			this.fullPath = this.basePath + File.separatorChar + this.mediaName + this.mediaExtension;
			this.file = new File(this.fullPath);
			if (this.file.exists())
				break;

			if (this.mediaExtension.equalsIgnoreCase("flv") || this.mediaExtension.equalsIgnoreCase("mp3"))
			{
				this.fullPath = this.basePath + File.separatorChar + this.mediaName + "." + this.mediaExtension;
				this.file = new File(this.fullPath);
			}
			else
			{
				this.fullPath = this.basePath + File.separatorChar + this.mediaName;
				this.file = new File(this.fullPath);
			}
			break;
		}
	}

	public long getFilePointer()
	{
		if (this.randomFile == null)
			return 0;
		
		try
		{
			return this.randomFile.getFilePointer();
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileRandomAccessReader.class).error("FileRandomAccessReader.getFilePointer: "+e.toString());
		}
		return 0;
	}

	public void seek(long pos)
	{
		if (this.randomFile == null)
			return;
		
		try
		{
			if (pos < 0)
				pos = 0;
			this.randomFile.seek(pos);
		}
		catch (Exception e)
		{
			if (!sentSeekError)
			{
    			String stackTrace = "unknown";
    			Throwable cause = e;
            	if (cause != null)
            	{
        			StackTraceElement[] elements = cause.getStackTrace();
        			if (elements != null)
        			{
        				if (elements.length > 0)
        					stackTrace = elements[0].getClassName()+"."+elements[0].getMethodName()+"("+elements[0].getFileName()+":"+elements[0].getLineNumber()+")";
        			}
        			
        			stackTrace = cause.toString() + " ("+stackTrace+")";
            	}

            	WMSLoggerFactory.getLogger(FileRandomAccessReader.class).error("DirectRandomAccessReader.seek["+this.mediaName+","+stackTrace+"]: "+e.toString());
				e.printStackTrace();
            	sentSeekError = true;
			}
		}
	}

	public int read(byte[] buf, int off, int size)
	{
		if (this.randomFile == null)
			return 0;
		
		try
		{
			return this.randomFile.read(buf, off, size);
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileRandomAccessReader.class).error("FileRandomAccessReader.read: "+e.toString());
		}
		return 0;
	}

	public void open() throws IOException
	{
		WMSLoggerFactory.getLogger(FileRandomAccessReader.class).info("FileRandomAccessReader.open["+this.mediaName+"]");
		if (this.randomFile != null)
			close();
		this.randomFile = new WowzaRandomAccessFile(new File(this.fullPath), "r");
	}

	public void close() throws IOException
	{
		WMSLoggerFactory.getLogger(FileRandomAccessReader.class).info("FileRandomAccessReader.close["+this.mediaName+"]");
		if (this.randomFile != null)
			this.randomFile.close();
		this.randomFile = null;
	}

	public boolean isOpen()
	{
		return this.randomFile != null;
	}
	
	public int getDirecton()
	{
		return this.direction;
	}

	public void setDirecton(int directon)
	{
		this.direction = direction;
	}
			
	public String getBasePath()
	{
		return this.basePath;
	}

	public String getMediaName()
	{
		return this.mediaName;
	}

	public String getMediaExtension()
	{
		return mediaExtension;
	}
	
	public boolean exists()
	{
		return this.file.exists();
	}
	
	public long lastModified()
	{
		try
		{
			return this.file.lastModified();
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileRandomAccessReader.class).error("FileRandomAccessReader.lastModified: "+e.toString());
		}
		return 0;
	}
	
	public long length()
	{
		try
		{
			return this.file.length();
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileRandomAccessReader.class).error("FileRandomAccessReader.length: "+e.toString());
		}
		return 0;
	}
	
	public String getPath()
	{
		return this.fullPath;
	}

}
