package com.wowza.wms.plugin.randomaccessreader.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.*;

import com.wowza.util.FileCache;
import com.wowza.wms.logging.WMSLoggerFactory;

public class HTTPCacheDownloader extends Thread
{
	public static final int CHUNKSIZE = 128*1024;
	
	HTTPCacheItem cacheItem = null;
	
	HTTPCacheDownloader (HTTPCacheItem cacheItem)
	{
		this.cacheItem = cacheItem;
	}
	
	public void run()
	{
		URL url = null;
		try
		{
			File tmppath = null;
			synchronized(this.cacheItem)
			{
				url = this.cacheItem.getUrl();
				tmppath = this.cacheItem.getFile();
			}
			
	        URLConnection urlConnection = url.openConnection();	        
	        BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), CHUNKSIZE);
	        
	        int buffersize = CHUNKSIZE;
	        byte[] buffer = new byte[buffersize];
	        while (true)
	        {
	        	int len = is.read(buffer);
	        	if (len > 0)
	        	{
	    	        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmppath, true));
	        		os.write(buffer, 0, len);
	    	        os.flush();
	    	        os.close();
	    			synchronized(this.cacheItem)
	    			{
	    				System.out.println("HTTPCacheDownloader.incBytesDownloaded: "+len);
	    				this.cacheItem.incBytesDownloaded(len);
	    				this.cacheItem.notify();
	    				if (this.cacheItem.getBytesDownloaded() >= this.cacheItem.getLength())
	    					break;
	    			}
	        	}
	        	if (len == -1)
	        		break;
	        }
	        is.close();
	        
			synchronized(this.cacheItem)
			{
				System.out.println("HTTPCacheDownloader.done: "+this.cacheItem.getBytesDownloaded()+"="+this.cacheItem.getLength());
				this.cacheItem.notify();
			}
	        
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileCache.class).error("cacheURL: ("+url.toString()+"): "+e.toString());
		}
	}
	
	public long getLength()
	{
		URL url = null;
		File tmppath = null;
		long ret = 0;
		
		synchronized(this.cacheItem)
		{
			url = this.cacheItem.getUrl();
			tmppath = this.cacheItem.getFile();
		}

		try
		{
			if (tmppath.exists())
				tmppath.delete();
	        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmppath, false));
	        os.close();
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileCache.class).error("getLength: deleteFile: "+e.toString());
		}
		
		try
		{
	        URLConnection urlConnection = url.openConnection();
	        String lenStr = urlConnection.getHeaderField("Content-Length");
	        if (lenStr != null)
	        {
	        	if (lenStr.length() > 0)
	        		ret = Long.parseLong(lenStr);
	        }
	        System.out.println("Length: "+ret);
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(FileCache.class).error("getLength: ("+url.toString()+"): "+e.toString());
			e.printStackTrace();
		}
		return ret;
	}
}
