package com.wowza.wms.plugin.randomaccessreader.http;

import java.io.File;
import java.net.*;

import com.wowza.util.*;
import com.wowza.wms.logging.WMSLoggerFactory;

public class HTTPCacheItem
{
	private String id;
	private URL url;
	private long length = -1;
	private long bytesDownloaded = 0;
	private HTTPCacheDownloader downloader = null;
	private String basePath = "";
	
	public HTTPCacheItem(URL url, String id, String basePath)
	{
		this.url = url;
		this.id = id; //URLUtils.urlToId(url);
		this.basePath = basePath;
		this.downloader = new HTTPCacheDownloader(this);
		
		this.length = this.downloader.getLength();
		startDownload();
	}
	
	private void startDownload()
	{
		this.downloader.setDaemon(true);
		this.downloader.start();
	}
	
	public synchronized File getFile()
	{
		return new File(this.basePath + File.separatorChar + this.id + ".cache");
	}
	
	public synchronized URL getUrl()
	{
		return this.url;
	}
	
	public synchronized String getId()
	{
		return this.id;
	}
	
	public synchronized void incBytesDownloaded(int size)
	{
		this.bytesDownloaded += size;
	}
	
	public synchronized long getBytesDownloaded()
	{
		return this.bytesDownloaded;
	}
	
	public synchronized long getLength()
	{
		return this.length;
	}
	
	public synchronized void blockForPos(long pos)
	{
		while (true)
		{
			if (pos > this.length)
				pos = this.length;
			
			System.out.println("blockForPos: "+pos+":"+this.bytesDownloaded);
			if (pos <= this.bytesDownloaded)
				break;
			
			try
			{
				this.wait();
			}
			catch (Exception e)
			{
				WMSLoggerFactory.getLogger(HTTPCacheItem.class).error("blockForPos: "+pos+"="+this.bytesDownloaded+" error: "+e.toString());
			}
		}
	}
}
