package com.wowza.wms.plugin.randomaccessreader.http;

import java.util.*;

public class HTTPCacheSingleton
{
	private static HTTPCacheSingleton instance = null;
	
	private Map<String, HTTPCacheItem> cacheItems = new HashMap<String, HTTPCacheItem>();
	
	public static HTTPCacheSingleton getInstance()
	{
		if (HTTPCacheSingleton.instance == null)
			HTTPCacheSingleton.instance = new HTTPCacheSingleton();
		return HTTPCacheSingleton.instance;
	}
	
	public synchronized HTTPCacheItem get(String id)
	{
		return cacheItems.get(id);
	}
	
	public synchronized HTTPCacheItem remove(String id)
	{
		return cacheItems.remove(id);
	}

	public synchronized boolean exists(String id)
	{
		return cacheItems.containsKey(id);
	}
	
	public synchronized void put(String id, HTTPCacheItem item)
	{
		cacheItems.put(id, item);
	}
}
