package com.wowza.wms.plugin.randomaccessreader.http;

import java.io.*;
import java.net.*;

import com.wowza.io.*;
import com.wowza.wms.logging.*;
import com.wowza.wms.stream.*;
import com.wowza.wms.application.*;

public class HTTPRandomAccessReaderDirect implements IRandomAccessReader
{
	private IApplicationInstance appInstance = null;
	private IMediaStream stream = null;
	private String basePath = null;
	private String mediaName = null;
	private String mediaExtension = null;
	private boolean isOpen = false;
	private long length = 0;
	private long lastModified = 0;
	private int direction = IRandomAccessReader.FORWARD;
	private long pos = 0;
	private URL url = null;
	private HTTPByteReader reader = null;
	private String path = null;
	private boolean isUrlValid = false;
	private int status = 200;
	
	public void init(IApplicationInstance appInstance, IMediaStream stream, String basePath, String mediaName, String mediaExtension)
	{
		this.appInstance = appInstance;
		this.stream = stream;
		this.basePath = basePath;
		this.mediaName = mediaName;
		this.mediaExtension = mediaExtension;
		
		WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).info("HTTPRandomAccessReaderDirect.init: basePath:"+this.basePath+" mediaName:"+this.mediaName+" extension:"+this.mediaExtension);

		this.length = 0;
		this.lastModified = 0;
		this.isUrlValid = false;
		this.status = 200;
		
		try
		{
			while(true)
			{
				this.url = new URL(this.mediaName);
				if (this.url == null)
					break;
				
				int port = 80;
				if (this.url.getPort() > 0)
					port = this.url.getPort();
				
				this.reader = new HTTPByteReader(this.url.getHost(), port);
				if (this.reader == null)
					break;
				
				this.path = this.url.getPath();
				if (this.url.getQuery() != null)
					this.path += "?"+this.url.getQuery();
				
				long[] headInfo = new long[HTTPByteReader.HEADINDEX_SIZE];
				headInfo = this.reader.head(this.path);
				if (headInfo == null)
					break;
				
				this.status = (int)headInfo[HTTPByteReader.HEADINDEX_STATUS];
				if (this.status < 200 || this.status >= 300)
					break;
				
				this.length = headInfo[HTTPByteReader.HEADINDEX_CONTENTLENGTH];
				this.lastModified = headInfo[HTTPByteReader.HEADINDEX_LASTMODIFIED];
				this.isUrlValid = true;
				WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).info("HTTPRandomAccessReaderDirect.init: status:"+this.status+" length:"+this.length+" lastModified:"+this.lastModified);
				break;
			}
		}
		catch (Exception e)
		{
			WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).error("HTTPRandomAccessReaderDirect.init:"+e.toString());
		}
	}

	public boolean isOpen()
	{
		return this.isOpen;
	}


	public void open() throws IOException
	{
		WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).info("HTTPRandomAccessReaderDirect.open["+this.mediaName+"]");
		if (this.isUrlValid)
			this.isOpen = true;
		else
		{
			throw new IOException("HTTPRandomAccessReaderDirect.open: Error: URL not found["+this.mediaName+"]: status: "+this.status);
		}
	}

	public void close() throws IOException
	{
		WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).info("HTTPRandomAccessReaderDirect.close["+this.mediaName+"]");
		if (this.reader != null)
			this.reader.close();

		this.reader = null;
		this.length = 0;
		this.lastModified = 0;
		this.isOpen = false;
		this.url = null;
		this.path = null;
		this.isUrlValid = false;
		this.status = 200;
	}

	public boolean exists()
	{
		return this.isUrlValid;
	}

	public long lastModified()
	{
		return this.lastModified;
	}

	public long length()
	{
		return this.length;
	}

	public String getBasePath()
	{
		return this.basePath;
	}

	public int getDirecton()
	{
		return direction;
	}

	public void setDirecton(int directon)
	{
		this.direction = directon;
	}

	public String getMediaExtension()
	{
		return this.mediaExtension;
	}

	public String getMediaName()
	{
		return this.mediaName;
	}

	public String getPath()
	{
		return this.basePath;
	}

	public long getFilePointer()
	{
		return this.pos;
	}

	public void seek(long pos)
	{
		if (pos < 0)
			pos = 0;
		this.pos = pos;
	}

	public int read(byte[] buf, int off, int size)
	{
		int readSize = 0;
		
		while(true)
		{
			if (!this.isOpen)
				break;
			
			if (this.reader == null)
				break;

			HTTPByteReaderResult result = this.reader.read(this.path, this.pos, size);
			if (result == null)
				break;
			
			readSize = (int)result.contentLength;
			if (readSize > 0)
			{
				System.arraycopy(result.buffer, (int)result.headerLength, buf, off, readSize);
				this.pos += readSize;
			}
			break;
		}
		
		//WMSLoggerFactory.getLogger(HTTPRandomAccessReaderDirect.class).info("HTTPRandomAccessReaderDirect.read["+this.mediaName+"]: pos:"+pos+" size:"+size+" readSize:"+readSize);

		return readSize;
	}

}
