/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.rtppush;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPPushPublishSession;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.util.RTPUtils;
import java.util.HashMap;
import java.util.Map;

public class ModuleRTPPusher
extends ModuleBase {
    private Map<Integer, RTPPushSession> rtpPushSessions = new HashMap<Integer, RTPPushSession>();
    private int rtpPushSessionNextId = 0;

    public void onAppStart(IApplicationInstance appInstance) {
        ModuleRTPPusher.getLogger().info("ModuleRTPPusher.onAppStart");
    }

    public void onAppStop(IApplicationInstance appInstance) {
        ModuleRTPPusher.getLogger().info("ModuleRTPPusher.onAppStop");
        this.stopAllRTPPushSessions();
    }

    public void stopRTPPushSession(int rtpPushSessionId) {
        RTPPushSession rtpPushSession = this.rtpPushSessions.get(new Integer(rtpPushSessionId));
        if (rtpPushSession != null && rtpPushSession.rtpSession != null) {
            RTPUtils.stopRTPPull((RTPPushPublishSession)rtpPushSession.rtpPushPublishSession);
            ModuleRTPPusher.getLogger().info("ModuleRTPPusher.stopRTPSession: " + rtpPushSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllRTPPushSessions() {
        Map<Integer, RTPPushSession> map = this.rtpPushSessions;
        synchronized (map) {
            for (Integer rtpPushSessionId : this.rtpPushSessions.keySet()) {
                this.stopRTPPushSession(rtpPushSessionId);
            }
            this.rtpPushSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRTPPushSessionList(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataArray ret = new AMFDataArray();
        Map<Integer, RTPPushSession> map = this.rtpPushSessions;
        synchronized (map) {
            for (Integer rtpPushSessionId : this.rtpPushSessions.keySet()) {
                RTPPushSession rtpPushSession = this.rtpPushSessions.get(rtpPushSessionId);
                if (rtpPushSession == null || rtpPushSession.rtpSession == null) continue;
                AMFDataObj obj = new AMFDataObj();
                obj.put("streamName", (AMFData)new AMFDataItem(rtpPushSession.streamName));
                obj.put("ipAddress", (AMFData)new AMFDataItem(rtpPushSession.ipAddress));
                obj.put("audioPort", (AMFData)new AMFDataItem(rtpPushSession.audioPort));
                obj.put("videoPort", (AMFData)new AMFDataItem(rtpPushSession.videoPort));
                obj.put("isRTPWrapped", (AMFData)new AMFDataItem(rtpPushSession.isRTPWrapped));
                obj.put("streamPacketizer", (AMFData)new AMFDataItem(rtpPushSession.streamPacketizer));
                obj.put("rtpPushSessionId", (AMFData)new AMFDataItem(rtpPushSession.rtpPushSessionId));
                ret.add((AMFData)obj);
            }
        }
        ModuleRTPPusher.sendResult((IClient)client, (AMFDataList)params, (AMFData)ret);
    }

    public void stopRTPPushSession(IClient client, RequestFunction function, AMFDataList params) {
        int rtpPushSessionId = Integer.parseInt(params.getString(3));
        this.stopRTPPushSession(rtpPushSessionId);
    }

    public void stopAllRTPPushSessions(IClient client, RequestFunction function, AMFDataList params) {
        this.stopAllRTPPushSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRTPPush(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataObj paramObj = params.getObject(3);
        RTPPushSession rtpPushSession = new RTPPushSession();
        rtpPushSession.streamName = paramObj.containsKey("streamName") ? paramObj.getString("streamName") : null;
        rtpPushSession.ipAddress = paramObj.containsKey("ipAddress") ? paramObj.getString("ipAddress") : "localhost";
        rtpPushSession.audioPort = paramObj.containsKey("audioPort") ? paramObj.getInt("audioPort") : 10000;
        rtpPushSession.videoPort = paramObj.containsKey("videoPort") ? paramObj.getInt("videoPort") : 10002;
        rtpPushSession.isRTPWrapped = paramObj.containsKey("isRTPWrapped") ? paramObj.getBoolean("isRTPWrapped") : true;
        rtpPushSession.streamPacketizer = paramObj.containsKey("streamPacketizer") ? paramObj.getBoolean("streamPacketizer") : false;
        int rtpPushSessionId = -1;
        if (rtpPushSession.streamName == null) {
            ModuleRTPPusher.getLogger().warn("ModuleRTPPush.startRTPPush: Stream name is missing:" + rtpPushSession.streamName);
        } else {
            RTPPushPublishSession rtpPushPublishSession = RTPUtils.startRTPPull((IApplicationInstance)client.getAppInstance(), (String)rtpPushSession.streamName, (boolean)rtpPushSession.streamPacketizer, (String)rtpPushSession.ipAddress, (int)rtpPushSession.audioPort, (int)rtpPushSession.videoPort, (boolean)rtpPushSession.isRTPWrapped);
            if (rtpPushPublishSession == null) {
                ModuleRTPPusher.getLogger().warn("ModuleRTPPush.startRTPPush: startRTPPush failed:" + rtpPushSession.streamName);
            } else {
                Map<Integer, RTPPushSession> map = this.rtpPushSessions;
                synchronized (map) {
                    ++this.rtpPushSessionNextId;
                    rtpPushSession.rtpPushSessionId = this.rtpPushSessionNextId;
                    rtpPushSession.rtpPushPublishSession = rtpPushPublishSession;
                    rtpPushSession.rtpSession = rtpPushPublishSession.getRTPSession();
                    this.rtpPushSessions.put(new Integer(rtpPushSession.rtpPushSessionId), rtpPushSession);
                    rtpPushSessionId = rtpPushSession.rtpPushSessionId;
                }
                ModuleRTPPusher.getLogger().info("ModuleRTPPusher.startRTPPush: RTP Session started: streamName:" + rtpPushSession.streamName + " ipAddress:" + rtpPushSession.ipAddress + " audioPort:" + rtpPushSession.audioPort + " videoPort:" + rtpPushSession.videoPort);
            }
        }
        ModuleRTPPusher.sendResult((IClient)client, (AMFDataList)params, (AMFData)new AMFDataItem(rtpPushSessionId));
    }

    class RTPPushSession {
        String streamName = null;
        String ipAddress = null;
        int audioPort = -1;
        int videoPort = -1;
        int rtpPushSessionId = 0;
        RTPPushPublishSession rtpPushPublishSession = null;
        RTPSession rtpSession = null;
        boolean streamPacketizer = false;
        boolean isRTPWrapped = false;

        RTPPushSession() {
        }
    }
}

