package com.wowza.wms.plugin.rtppush;

import java.util.*;

import com.wowza.wms.module.*;
import com.wowza.wms.request.*;
import com.wowza.wms.rtp.model.*;
import com.wowza.wms.util.*;
import com.wowza.wms.amf.*;
import com.wowza.wms.application.*;
import com.wowza.wms.client.*;

public class ModuleRTPPusher extends ModuleBase
{
	class RTPPushSession
	{
		String streamName = null;
		String ipAddress = null;
		int audioPort = -1;
		int videoPort = -1;
		int rtpPushSessionId = 0;
		RTPPushPublishSession rtpPushPublishSession = null;
		RTPSession rtpSession = null;
		boolean streamPacketizer = false;
		boolean isRTPWrapped = false;
	}
	private Map<Integer, RTPPushSession> rtpPushSessions = new HashMap<Integer, RTPPushSession>();
	private int rtpPushSessionNextId = 0;
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleRTPPusher.onAppStart");
	}

	public void onAppStop(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleRTPPusher.onAppStop");
		stopAllRTPPushSessions();
	}
	
	public void stopRTPPushSession(int rtpPushSessionId)
	{
		while(true)
		{
			RTPPushSession rtpPushSession = rtpPushSessions.get(new Integer(rtpPushSessionId));
			if (rtpPushSession == null)
				break;
			if (rtpPushSession.rtpSession == null)
				break;
			
			RTPUtils.stopRTPPull(rtpPushSession.rtpPushPublishSession);
			getLogger().info("ModuleRTPPusher.stopRTPSession: "+rtpPushSessionId);
			break;
		}
	}
	
	public void stopAllRTPPushSessions()
	{
		synchronized(rtpPushSessions)
		{
			Iterator<Integer> iter = rtpPushSessions.keySet().iterator();
			while(iter.hasNext())
			{
				Integer rtpPushSessionId = iter.next();
				stopRTPPushSession(rtpPushSessionId.intValue());
			}
			rtpPushSessions.clear();
		}
	}
	
	public void getRTPPushSessionList(IClient client, RequestFunction function, AMFDataList params)
	{
		AMFDataArray ret = new AMFDataArray();
		
		synchronized(rtpPushSessions)
		{
			Iterator<Integer> iter = rtpPushSessions.keySet().iterator();
			while(iter.hasNext())
			{
				Integer rtpPushSessionId = iter.next();
				RTPPushSession rtpPushSession = rtpPushSessions.get(rtpPushSessionId);
				if (rtpPushSession == null)
					continue;
				if (rtpPushSession.rtpSession == null)
					continue;
				
				AMFDataObj obj = new AMFDataObj();
				
				obj.put("streamName", new AMFDataItem(rtpPushSession.streamName));
				obj.put("ipAddress", new AMFDataItem(rtpPushSession.ipAddress));
				obj.put("audioPort", new AMFDataItem(rtpPushSession.audioPort));
				obj.put("videoPort", new AMFDataItem(rtpPushSession.videoPort));
				obj.put("isRTPWrapped", new AMFDataItem(rtpPushSession.isRTPWrapped));
				obj.put("streamPacketizer", new AMFDataItem(rtpPushSession.streamPacketizer));
				obj.put("rtpPushSessionId", new AMFDataItem(rtpPushSession.rtpPushSessionId));
				
				ret.add(obj);
			}
		}
		
		sendResult(client, params, ret);
	}
	
	public void stopRTPPushSession(IClient client, RequestFunction function, AMFDataList params)
	{
		int rtpPushSessionId = Integer.parseInt(params.getString(PARAM1));
		stopRTPPushSession(rtpPushSessionId);
	}
	
	public void stopAllRTPPushSessions(IClient client, RequestFunction function, AMFDataList params)
	{
		stopAllRTPPushSessions();
	}
	
	public void startRTPPush(IClient client, RequestFunction function, AMFDataList params)
	{		
		AMFDataObj paramObj = params.getObject(PARAM1);

		RTPPushSession rtpPushSession = new RTPPushSession();

		rtpPushSession.streamName = paramObj.containsKey("streamName")?paramObj.getString("streamName"):null;
		rtpPushSession.ipAddress = paramObj.containsKey("ipAddress")?paramObj.getString("ipAddress"):"localhost";
		rtpPushSession.audioPort = paramObj.containsKey("audioPort")?paramObj.getInt("audioPort"):10000;
		rtpPushSession.videoPort = paramObj.containsKey("videoPort")?paramObj.getInt("videoPort"):10002;
		rtpPushSession.isRTPWrapped = paramObj.containsKey("isRTPWrapped")?paramObj.getBoolean("isRTPWrapped"):true;
		rtpPushSession.streamPacketizer = paramObj.containsKey("streamPacketizer")?paramObj.getBoolean("streamPacketizer"):false;
		
		int rtpPushSessionId = -1;
		while(true)
		{
			if (rtpPushSession.streamName == null)
			{
				getLogger().warn("ModuleRTPPush.startRTPPush: Stream name is missing:"+rtpPushSession.streamName);
				break;
			}
			
			RTPPushPublishSession rtpPushPublishSession = RTPUtils.startRTPPull(client.getAppInstance(), rtpPushSession.streamName, rtpPushSession.streamPacketizer, rtpPushSession.ipAddress, rtpPushSession.audioPort, rtpPushSession.videoPort, rtpPushSession.isRTPWrapped);
			if (rtpPushPublishSession == null)
			{
				getLogger().warn("ModuleRTPPush.startRTPPush: startRTPPush failed:"+rtpPushSession.streamName);
				break;
			}

			synchronized(rtpPushSessions)
			{
				rtpPushSessionNextId++;				
				rtpPushSession.rtpPushSessionId = rtpPushSessionNextId;
				rtpPushSession.rtpPushPublishSession = rtpPushPublishSession;
				rtpPushSession.rtpSession = rtpPushPublishSession.getRTPSession();
				rtpPushSessions.put(new Integer(rtpPushSession.rtpPushSessionId), rtpPushSession);
				rtpPushSessionId = rtpPushSession.rtpPushSessionId;
			}

			getLogger().info("ModuleRTPPusher.startRTPPush: RTP Session started: streamName:"+rtpPushSession.streamName+" ipAddress:"+rtpPushSession.ipAddress+" audioPort:"+rtpPushSession.audioPort+" videoPort:"+rtpPushSession.videoPort);
			break;
		}
		
		sendResult(client, params, new AMFDataItem(rtpPushSessionId));
	}
}
