/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.textchat;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObject;
import java.util.HashMap;
import java.util.Map;

public class ModuleTextChat
extends ModuleBase {
    private Map<String, ISharedObject> chatSharedOjects = new HashMap<String, ISharedObject>();
    private long nextChatId = 0L;
    private long keepCount = 20L;
    private int purgeCount = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISharedObject getChatSharedObject(String string, IApplicationInstance iApplicationInstance) {
        ISharedObject iSharedObject = null;
        Map<String, ISharedObject> map = this.chatSharedOjects;
        synchronized (map) {
            iSharedObject = this.chatSharedOjects.get(string);
            if (iSharedObject == null) {
                ModuleTextChat.getLogger().info("ModuleTextChat.getChatSharedObject: create shared object: " + string);
                ISharedObjects iSharedObjects = iApplicationInstance.getSharedObjects();
                iSharedObject = new SharedObject(string);
                iSharedObjects.put(string, iSharedObject);
                this.chatSharedOjects.put(string, iSharedObject);
                iSharedObject.setProperty("lastChatId", (AMFData)new AMFDataItem(this.nextChatId));
                iSharedObject.acquire();
            }
        }
        return iSharedObject;
    }

    public void initSharedObject(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        ModuleTextChat.getLogger().info("ModuleTextChat.initSharedObject: init shared object: " + string);
        ISharedObject iSharedObject = this.getChatSharedObject(string, iClient.getAppInstance());
        ModuleTextChat.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (String)string);
    }

    private void purgeDeleted(ISharedObject iSharedObject) {
        int n = iSharedObject.getVersion() - this.purgeCount;
        if (n > 0) {
            iSharedObject.purge(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessages(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        ISharedObject iSharedObject = this.getChatSharedObject(string, iClient.getAppInstance());
        if (iSharedObject != null) {
            iSharedObject.lock();
            try {
                iSharedObject.clear();
                this.purgeDeleted(iSharedObject);
            }
            catch (Exception exception) {
                ModuleTextChat.getLogger().error("ModuleTextChat.clearMessages: " + exception.toString());
            }
            finally {
                iSharedObject.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        AMFDataObj aMFDataObj = aMFDataList.getObject(4);
        ISharedObject iSharedObject = this.getChatSharedObject(string, iClient.getAppInstance());
        if (iSharedObject != null) {
            iSharedObject.lock();
            try {
                ++this.nextChatId;
                String string2 = "chatData" + this.nextChatId;
                ModuleTextChat.getLogger().info("ModuleTextChat.addMessage: message id: " + string2);
                iSharedObject.setProperty(string2, (AMFData)aMFDataObj);
                iSharedObject.setProperty("lastChatId", (AMFData)new AMFDataItem(this.nextChatId));
                if (this.nextChatId % this.keepCount == 0L) {
                    String string3;
                    for (long i = this.nextChatId - this.keepCount; i > 0L && iSharedObject.getSlot(string3 = "chatData" + i) != null; --i) {
                        iSharedObject.deleteSlot(string3);
                    }
                    this.purgeDeleted(iSharedObject);
                }
            }
            catch (Exception exception) {
                ModuleTextChat.getLogger().error("ModuleTextChat.addMessage: " + exception.toString());
            }
            finally {
                iSharedObject.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        Map<String, ISharedObject> map = this.chatSharedOjects;
        synchronized (map) {
            for (String string : this.chatSharedOjects.keySet()) {
                ModuleTextChat.getLogger().info("ModuleTextChat.onAppStop: release shared object: " + string);
                ISharedObject iSharedObject = this.chatSharedOjects.get(string);
                iSharedObject.release();
            }
            this.chatSharedOjects.clear();
        }
    }
}

