#!/bin/bash

clear
OSPATH=
if [[ $OSTYPE == darwin* ]] ;
then
    OSPATH=osx
    WMSAPP_HOME=/Library/WowzaStreamingEngine
else
    OSPATH=linux
    WMSAPP_HOME=/usr/local/WowzaStreamingEngine
fi

if [ ! -d "$WMSAPP_HOME" ]
then
    pushd "$PWD" 1>/dev/null
    cd ../../..
        INSTALL_DIR=`pwd`
    popd 1>/dev/null
    if [ ! -d "$WMSAPP_HOME/lib" ] || [ ! -d "$WMSAPP_HOME/conf" ] || [ ! -d "$WMSAPP_HOME/bin" ] || [ ! -d "$WMSAPP_HOME/manager" ]
    then
        echo "$INSTALL_DIR does not appear to be a Wowza Streaming Engine install directory.  No Update Performed."
        echo ""
        echo "This update should be placed in a sub directory of [INSTALL DIR]/updates directory."
        echo ""
        echo "An example would be to unzip the update into "
        echo ""
        echo "  $OSPATH/WowzaStreamingEngine/updates/updatelog4j"
        echo ""
        echo "and then change directory to "
        echo ""
        echo "  cd $OSPATH/WowzaStreamingEngine/updates/updatelog4j"
        echo ""
        echo "and executing"
        echo ""
        echo "  sudo ./updatelog4j.sh"
        echo ""
        echo "from there."
        exit 1
    fi
fi

echo "Verifying running as administrative user"
if [ $EUID -ne 0 ]; then
	if [ "$(id -u)" != "0" ]; then
		echo "root privileges are required to update the Wowza Streaming Engine.  Please retry with root privileges" 1>&2
		exit 1
	fi
	exit 1
fi

_PNAME="Wowza Streaming Engine"

if [ -n "`ps ax|grep wms-bootstrap.jar|grep -v grep`" ]; then
	echo "$_PNAME appears to be running.  Please stop it before continuing."
	exit 1
fi

if [ -n "`ps ax|grep wms-tomcat | grep -v grep`" ]; then
	echo "$_PNAME Manager appears to be running.  Please stop it before continuing."
	exit 1
fi

if ! command -v zip &> /dev/null
then
    "$OSPATH/bin/java" -m log4jupdater/com.wowza.solutions.log4jupdater.Log4jUpdater $WMSAPP_HOME
else
    mkdir -p WEB-INF/lib/
    cp log4j*.jar WEB-INF/lib/

    echo "updating $WMSAPP_HOME/lib"
    if compgen -G "$WMSAPP_HOME/lib/log4j-api*.jar" > /dev/null
    then
        echo deleteing $WMSAPP_HOME/lib/log4j-api*.jar
        rm $WMSAPP_HOME/lib/log4j-api*.jar
        echo copying ./log4j-api*.jar to $WMSAPP_HOME/lib/
        cp ./log4j-api*.jar $WMSAPP_HOME/lib/
    else
        echo "$WMSAPP_HOME/lib/log4j-api*.jar not found. Not Updating"
    fi
    if compgen -G "$WMSAPP_HOME/lib/log4j-core*.jar" > /dev/null
    then
        echo deleteing $WMSAPP_HOME/lib/log4j-core*.jar
        rm $WMSAPP_HOME/lib/log4j-core*.jar
        echo copying ./log4j-core*.jar to $WMSAPP_HOME/lib/
        cp ./log4j-core*.jar $WMSAPP_HOME/lib/
    else
        echo "$WMSAPP_HOME/lib/log4j-core*.jar not found. Not Updating"
    fi

    echo "updating $WMSAPP_HOME/manager/lib/WMSManager.war"
    unzip -l $WMSAPP_HOME/manager/lib/WMSManager.war | grep -q "WEB-INF/lib/log4j-api*"
    if [ "$?" == "0" ]
    then
        zip -d $WMSAPP_HOME/manager/lib/WMSManager.war "WEB-INF/lib/log4j-api*"
        zip -r $WMSAPP_HOME/manager/lib/WMSManager.war WEB-INF/lib/log4j-api*.jar
    else
        echo "WEB-INF/lib/log4j-api*.jar not found in $WMSAPP_HOME/manager/lib/WMSManager.war. Not Updating"
    fi
    unzip -l $WMSAPP_HOME/manager/lib/WMSManager.war | grep -q "WEB-INF/lib/log4j-core*"
    if [ "$?" == "0" ]
    then
        zip -d $WMSAPP_HOME/manager/lib/WMSManager.war "WEB-INF/lib/log4j-core*"
        zip -r $WMSAPP_HOME/manager/lib/WMSManager.war WEB-INF/lib/log4j-core*.jar
    else
        echo "WEB-INF/lib/log4j-core*.jar not found in $WMSAPP_HOME/manager/lib/WMSManager.war. Not Updating"
    fi
    rm -rf WEB-INF
fi
echo "Update Complete. Please restart services"
